/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.networking.packet.instrument.util;

import com.cstav.genshinstrument.event.InstrumentOpenStateChangedEvent;
import com.cstav.genshinstrument.networking.GIPacketHandler;
import com.cstav.genshinstrument.networking.OpenInstrumentPacketSender;
import com.cstav.genshinstrument.networking.packet.instrument.NoteSoundMetadata;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.NotifyInstrumentOpenPacket;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.OpenInstrumentPacket;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.S2CNotePacket;
import com.cstav.genshinstrument.networking.packet.instrument.util.S2CNotePacketDelegate;
import com.cstav.genshinstrument.util.CommonUtil;
import com.cstav.genshinstrument.util.InstrumentEntityData;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5712;

public class InstrumentPacketUtil {
    public static final int PLAY_DISTANCE = 24;

    public static <T, P extends S2CNotePacket<T>> P sendPlayerPlayNotePackets(class_1297 initiator, T sound, NoteSoundMetadata soundMeta, S2CNotePacketDelegate<T, P> notePacketDelegate) {
        P packet = notePacketDelegate.create(Optional.of(initiator.method_5628()), sound, soundMeta);
        for (class_1657 listener : InstrumentPacketUtil.noteListeners(initiator.method_37908(), soundMeta.pos())) {
            GIPacketHandler.sendToClient(packet, (class_3222)listener);
        }
        initiator.method_37908().method_43276(class_5712.field_39415, soundMeta.pos(), class_5712.class_7397.method_43285((class_1297)initiator));
        return packet;
    }

    public static <T, P extends S2CNotePacket<T>> P sendPlayerPlayNotePackets(class_1297 initiator, T sound, class_2960 instrumentId, int pitch, int volume, S2CNotePacketDelegate<T, P> notePacketDelegate) {
        return InstrumentPacketUtil.sendPlayerPlayNotePackets(initiator, sound, new NoteSoundMetadata(initiator.method_24515(), pitch, volume, instrumentId, Optional.empty()), notePacketDelegate);
    }

    public static <T, P extends S2CNotePacket<T>> P sendPlayNotePackets(class_1937 level, T sound, NoteSoundMetadata soundMeta, S2CNotePacketDelegate<T, P> notePacketDelegate) {
        P packet = notePacketDelegate.create(Optional.empty(), sound, soundMeta);
        for (class_1657 listener : InstrumentPacketUtil.noteListeners(level, soundMeta.pos())) {
            GIPacketHandler.sendToClient(packet, (class_3222)listener);
        }
        class_2680 bs = level.method_8320(soundMeta.pos());
        if (bs != class_2246.field_10124.method_9564()) {
            level.method_43276(class_5712.field_39415, soundMeta.pos(), class_5712.class_7397.method_43287((class_2680)bs));
        } else {
            level.method_33596(null, class_5712.field_39415, soundMeta.pos());
        }
        return packet;
    }

    public static <T, P extends S2CNotePacket<T>> P sendPlayNotePackets(class_1937 level, class_2338 pos, T sound, class_2960 instrumentId, int pitch, int volume, S2CNotePacketDelegate<T, P> notePacketDelegate) {
        return InstrumentPacketUtil.sendPlayNotePackets(level, sound, new NoteSoundMetadata(pos, pitch, volume, instrumentId, Optional.empty()), notePacketDelegate);
    }

    public static List<class_1657> noteListeners(class_1937 level, class_2338 pos) {
        return CommonUtil.getPlayersInArea(level, new class_238(pos).method_1014(24.0));
    }

    public static void setInstrumentClosed(class_3222 player) {
        if (!InstrumentEntityData.isOpen((class_1657)player)) {
            return;
        }
        InstrumentEntityData.setClosed((class_1657)player);
        player.method_37908().method_18456().forEach(oPlayer -> GIPacketHandler.sendToClient(new NotifyInstrumentOpenPacket(player.method_5667()), (class_3222)oPlayer));
        boolean isItem = InstrumentEntityData.isItem((class_1657)player);
        ((InstrumentOpenStateChangedEvent)InstrumentOpenStateChangedEvent.EVENT.invoker()).triggered(new InstrumentOpenStateChangedEvent.InstrumentOpenStateChangedEventArgs(false, (class_1657)player, isItem ? Optional.empty() : Optional.of(InstrumentEntityData.getBlockPos((class_1657)player)), isItem ? Optional.of(InstrumentEntityData.getHand((class_1657)player)) : Optional.empty()));
    }

    public static boolean sendOpenPacket(class_3222 player, class_1268 usedHand, OpenInstrumentPacketSender onOpenRequest) {
        return InstrumentPacketUtil.sendOpenPacket(player, usedHand, onOpenRequest, null);
    }

    public static boolean sendOpenPacket(class_3222 player, OpenInstrumentPacketSender onOpenRequest, class_2338 pos) {
        return InstrumentPacketUtil.sendOpenPacket(player, null, onOpenRequest, pos);
    }

    private static boolean sendOpenPacket(class_3222 player, class_1268 usedHand, OpenInstrumentPacketSender onOpenRequest, class_2338 pos) {
        NotifyInstrumentOpenPacket instrumentOpenPacket;
        if (pos == null) {
            InstrumentEntityData.setOpen((class_1657)player, usedHand);
            instrumentOpenPacket = new NotifyInstrumentOpenPacket(player.method_5667(), usedHand);
        } else {
            InstrumentEntityData.setOpen((class_1657)player, pos);
            instrumentOpenPacket = new NotifyInstrumentOpenPacket(player.method_5667(), pos);
        }
        player.method_37908().method_18456().forEach(otherPlayer -> GIPacketHandler.sendToClient(instrumentOpenPacket, (class_3222)otherPlayer));
        ((InstrumentOpenStateChangedEvent)InstrumentOpenStateChangedEvent.EVENT.invoker()).triggered(new InstrumentOpenStateChangedEvent.InstrumentOpenStateChangedEventArgs(true, (class_1657)player, pos == null ? Optional.empty() : Optional.of(pos), pos == null ? Optional.of(usedHand) : Optional.empty()));
        onOpenRequest.send(player);
        return true;
    }

    public static void sendOpenPacket(class_3222 player, class_2960 instrumentID) {
        GIPacketHandler.sendToClient(new OpenInstrumentPacket(instrumentID), player);
    }
}

