/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.networking.packet.instrument.s2c;

import com.cstav.genshinstrument.event.InstrumentOpenStateChangedEvent;
import com.cstav.genshinstrument.networking.IModPacket;
import com.cstav.genshinstrument.util.InstrumentEntityData;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_310;

public class NotifyInstrumentOpenPacket
implements IModPacket {
    private final UUID playerUUID;
    private final boolean isOpen;
    private final Optional<class_2338> pos;
    private final Optional<class_1268> hand;

    public NotifyInstrumentOpenPacket(UUID playerUUID) {
        this.playerUUID = playerUUID;
        this.isOpen = false;
        this.pos = Optional.empty();
        this.hand = Optional.empty();
    }

    public NotifyInstrumentOpenPacket(UUID playerUUID, class_2338 pos) {
        this.playerUUID = playerUUID;
        this.isOpen = true;
        this.pos = Optional.of(pos);
        this.hand = Optional.empty();
    }

    public NotifyInstrumentOpenPacket(UUID playerUUID, class_1268 hand) {
        this.playerUUID = playerUUID;
        this.isOpen = true;
        this.pos = Optional.empty();
        this.hand = Optional.of(hand);
    }

    public NotifyInstrumentOpenPacket(class_2540 buf) {
        this.playerUUID = buf.method_10790();
        this.isOpen = buf.readBoolean();
        this.pos = buf.method_37436(class_2540::method_10811);
        this.hand = buf.method_37436(fbb -> (class_1268)fbb.method_10818(class_1268.class));
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10797(this.playerUUID);
        buf.writeBoolean(this.isOpen);
        buf.method_37435(this.pos, class_2540::method_10807);
        buf.method_37435(this.hand, class_2540::method_10817);
    }

    @Override
    public void handle(class_1657 player, PacketSender responseSender) {
        class_1657 _player = class_310.method_1551().field_1687.method_18470(this.playerUUID);
        if (this.isOpen) {
            if (this.pos.isPresent()) {
                InstrumentEntityData.setOpen(_player, this.pos.get());
            } else {
                InstrumentEntityData.setOpen(_player, this.hand.get());
            }
        } else {
            InstrumentEntityData.setClosed(_player);
        }
        ((InstrumentOpenStateChangedEvent)InstrumentOpenStateChangedEvent.EVENT.invoker()).triggered(new InstrumentOpenStateChangedEvent.InstrumentOpenStateChangedEventArgs(this.isOpen, player, this.pos, this.hand));
    }
}

