/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.networking;

import com.cstav.genshinstrument.networking.IModPacket;
import com.cstav.genshinstrument.networking.packet.instrument.c2s.C2SHeldNoteSoundPacket;
import com.cstav.genshinstrument.networking.packet.instrument.c2s.C2SNoteSoundPacket;
import com.cstav.genshinstrument.networking.packet.instrument.c2s.CloseInstrumentPacket;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.NotifyInstrumentOpenPacket;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.OpenInstrumentPacket;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.S2CHeldNoteSoundPacket;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.S2CNoteSoundPacket;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;

public class GIPacketHandler {
    private static final List<Class<IModPacket>> S2C_PACKETS = List.of(new Class[]{S2CNoteSoundPacket.class, OpenInstrumentPacket.class, NotifyInstrumentOpenPacket.class, S2CHeldNoteSoundPacket.class});
    private static final List<Class<IModPacket>> C2S_PACKETS = List.of(new Class[]{CloseInstrumentPacket.class, C2SNoteSoundPacket.class, C2SHeldNoteSoundPacket.class});

    public static void registerClientPackets() {
        for (Class<IModPacket> packetClass : S2C_PACKETS) {
            ClientPlayNetworking.registerGlobalReceiver(IModPacket.type(packetClass), IModPacket::handle);
        }
    }

    public static void registerServerPackets() {
        for (Class<IModPacket> packetClass : C2S_PACKETS) {
            ServerPlayNetworking.registerGlobalReceiver(IModPacket.type(packetClass), IModPacket::handle);
        }
    }

    public static void sendToServer(FabricPacket packet) {
        ClientPlayNetworking.send((FabricPacket)packet);
    }

    public static void sendToClient(FabricPacket packet, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (FabricPacket)packet);
    }
}

