/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.event;

import com.cstav.genshinstrument.block.partial.InstrumentBlockEntity;
import com.cstav.genshinstrument.event.impl.Cancelable;
import com.cstav.genshinstrument.event.impl.EventArgs;
import com.cstav.genshinstrument.event.impl.ModEvent;
import com.cstav.genshinstrument.networking.packet.instrument.NoteSoundMetadata;
import com.cstav.genshinstrument.util.InstrumentEntityData;
import java.util.Optional;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;

@FunctionalInterface
public interface InstrumentPlayedEvent<T>
extends ModEvent<InstrumentPlayedEventArgs<T>> {
    public static final Event<InstrumentPlayedEvent<Object>> EVENT = EventFactory.createArrayBacked(InstrumentPlayedEvent.class, listeners -> args -> ModEvent.handleEvent((ModEvent[])listeners, (EventArgs)args));

    public static <E extends ModEvent<A>, A extends InstrumentPlayedEventArgs<?>> void handleInsEvent(E[] listeners, A args) {
        InstrumentPlayedEvent.handleInsEvent(listeners, args, (boolean)true);
    }

    public static <E extends ModEvent<A>, A extends InstrumentPlayedEventArgs<?>> void handleInsEvent(E[] listeners, A args, boolean callMain) {
        ModEvent.handleEvent(listeners, args);
        if (callMain) {
            ((InstrumentPlayedEvent)EVENT.invoker()).triggered(args);
        }
    }

    @Cancelable
    public static class InstrumentPlayedEventArgs<T>
    extends EventArgs {
        private final T sound;
        private final NoteSoundMetadata soundMeta;
        private final class_1937 level;
        private final Optional<EntityInfo> entityInfo;

        public boolean isByEntity() {
            return this.entityInfo.isPresent();
        }

        public boolean isByPlayer() {
            return this.isByEntity() && this.entityInfo.get().entity instanceof class_1657;
        }

        public InstrumentPlayedEventArgs(class_1937 level, T sound, NoteSoundMetadata soundMeta) {
            this.level = level;
            this.sound = sound;
            this.soundMeta = soundMeta;
            this.entityInfo = Optional.empty();
        }

        public InstrumentPlayedEventArgs(class_1297 initiator, T sound, NoteSoundMetadata soundMeta) {
            this.level = initiator.method_37908();
            this.sound = sound;
            this.soundMeta = soundMeta;
            this.entityInfo = Optional.of(new EntityInfo(initiator));
        }

        public T sound() {
            return this.sound;
        }

        public NoteSoundMetadata soundMeta() {
            return this.soundMeta;
        }

        public class_1937 level() {
            return this.level;
        }

        public Optional<EntityInfo> entityInfo() {
            return this.entityInfo;
        }

        public float volume() {
            return (float)this.soundMeta.volume() / 100.0f;
        }

        public class EntityInfo {
            public final class_1297 entity;
            public final Optional<class_1268> hand;
            protected final InstrumentPlayedEventArgs<T> baseEvent;

            public EntityInfo(class_1297 entity) {
                class_1657 player;
                this.baseEvent = InstrumentPlayedEventArgs.this;
                this.entity = entity;
                this.hand = entity instanceof class_1657 && InstrumentEntityData.isItem(player = (class_1657)entity) ? Optional.of(InstrumentEntityData.getHand(player)) : Optional.empty();
            }

            public boolean isItemInstrument() {
                return this.hand.isPresent();
            }

            public boolean isBlockInstrument() {
                return !this.isItemInstrument() && InstrumentPlayedEventArgs.this.level.method_8321(this.baseEvent.soundMeta.pos()) instanceof InstrumentBlockEntity;
            }

            public boolean isNotInstrument() {
                return !this.isBlockInstrument() && !this.isItemInstrument();
            }
        }
    }
}

