/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.event;

import com.cstav.genshinstrument.block.partial.AbstractInstrumentBlock;
import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.IHeldInstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.SoundTypeOptionsScreen;
import com.cstav.genshinstrument.client.midi.MidiController;
import com.cstav.genshinstrument.event.HeldNoteSoundPlayedEvent;
import com.cstav.genshinstrument.event.InstrumentPlayedEvent;
import com.cstav.genshinstrument.event.MidiEvent;
import com.cstav.genshinstrument.event.PosePlayerArmEvent;
import com.cstav.genshinstrument.item.ItemPoseModifier;
import com.cstav.genshinstrument.networking.packet.instrument.util.HeldSoundPhase;
import com.cstav.genshinstrument.sound.held.HeldNoteSounds;
import com.cstav.genshinstrument.util.InstrumentEntityData;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2382;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

@Environment(value=EnvType.CLIENT)
public abstract class ClientEvents {
    private static final class_310 MINECRAFT = class_310.method_1551();

    public static void register() {
        ClientTickEvents.START_CLIENT_TICK.register(ClientEvents::onClientTick);
        ServerWorldEvents.UNLOAD.register(ClientEvents::onLevelUnload);
        InstrumentPlayedEvent.EVENT.register(ClientEvents::onInstrumentPlayed);
        HeldNoteSoundPlayedEvent.EVENT.register(ClientEvents::onHeldNoteSound);
        PosePlayerArmEvent.EVENT.register(ClientEvents::posePlayerArmEvent);
        ClientLifecycleEvents.CLIENT_STOPPING.register(ClientEvents::onGameShutdown);
        MidiEvent.EVENT.register(ClientEvents::onMidiEvent);
    }

    private static void poseForBlockInstrument(PosePlayerArmEvent.PosePlayerArmEventArgs args, class_1657 player) {
        class_2248 block = player.method_37908().method_8320(InstrumentEntityData.getBlockPos(player)).method_26204();
        if (!(block instanceof AbstractInstrumentBlock)) {
            return;
        }
        AbstractInstrumentBlock blockInstrument = (AbstractInstrumentBlock)block;
        if (!InstrumentEntityData.isOpen(args.player) || InstrumentEntityData.isItem(args.player)) {
            return;
        }
        blockInstrument.onPosePlayerArm(args);
    }

    private static void poseForItemInstrument(PosePlayerArmEvent.PosePlayerArmEventArgs args, class_1657 player) {
        class_1799 instrumentItem = player.method_5998(InstrumentEntityData.getHand(player));
        if (instrumentItem == class_1799.field_8037) {
            return;
        }
        class_1792 class_17922 = instrumentItem.method_7909();
        if (!(class_17922 instanceof ItemPoseModifier)) {
            return;
        }
        ItemPoseModifier item = (ItemPoseModifier)class_17922;
        if (!InstrumentEntityData.isOpen(args.player) || !InstrumentEntityData.isItem(args.player)) {
            return;
        }
        item.onPosePlayerArm(args);
    }

    public static void posePlayerArmEvent(PosePlayerArmEvent.PosePlayerArmEventArgs args) {
        class_1657 player = args.player;
        if (!InstrumentEntityData.isOpen(player)) {
            return;
        }
        if (InstrumentEntityData.isItem(player)) {
            ClientEvents.poseForItemInstrument(args, player);
        } else {
            ClientEvents.poseForBlockInstrument(args, player);
        }
    }

    public static void onClientTick(class_310 mc) {
        InstrumentScreen.getCurrentScreen(mc).ifPresent(InstrumentScreen::handleAbruptClosing);
    }

    public static void onInstrumentPlayed(InstrumentPlayedEvent.InstrumentPlayedEventArgs<?> args) {
        if (!ClientEvents.validateSharedScreen(args)) {
            return;
        }
        if (!((Boolean)ModClientConfigs.SHARED_INSTRUMENT.get()).booleanValue()) {
            return;
        }
        if (!args.soundMeta().pos().method_19771((class_2382)ClientEvents.MINECRAFT.field_1724.method_24515(), 5.5)) {
            return;
        }
        ClientEvents.foreignPlayableInstrumentScreen(args).ifPresent(screen -> screen.foreignPlay(args));
    }

    public static void onHeldNoteSound(HeldNoteSoundPlayedEvent.HeldNoteSoundPlayedEventArgs args) {
        if (args.phase != HeldSoundPhase.RELEASE) {
            return;
        }
        if (!ClientEvents.validateSharedScreen(args)) {
            return;
        }
        ClientEvents.foreignPlayableInstrumentScreen(args).filter(screen -> screen instanceof IHeldInstrumentScreen).map(screen -> (IHeldInstrumentScreen)((Object)screen)).ifPresent(screen -> screen.releaseForeign(args));
    }

    private static boolean validateSharedScreen(InstrumentPlayedEvent.InstrumentPlayedEventArgs<?> event) {
        class_1297 initiator;
        if (!event.level().field_9236) {
            return false;
        }
        if (!((Boolean)ModClientConfigs.SHARED_INSTRUMENT.get()).booleanValue()) {
            return false;
        }
        return !event.isByPlayer() || !(initiator = event.entityInfo().get().entity).equals((Object)ClientEvents.MINECRAFT.field_1724);
    }

    private static Optional<InstrumentScreen> foreignPlayableInstrumentScreen(InstrumentPlayedEvent.InstrumentPlayedEventArgs<?> event) {
        return InstrumentScreen.getCurrentScreen(MINECRAFT).filter(screen -> event.soundMeta().noteIdentifier().isEmpty() || screen.getInstrumentId().equals((Object)event.soundMeta().instrumentId()));
    }

    public static void onLevelUnload(MinecraftServer server, class_3218 world) {
        HeldNoteSounds.releaseAll();
    }

    public static void onMidiEvent(MidiEvent.MidiEventArgs args) {
        InstrumentScreen.getCurrentScreen(class_310.method_1551()).filter(InstrumentScreen::isMidiInstrument).ifPresent(instrument -> instrument.midiReceiver.onMidi(args));
        SoundTypeOptionsScreen.onMidiReceivedEvent(args);
    }

    public static void onGameShutdown(class_310 client) {
        MidiController.unloadDevice();
    }
}

