/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.options.instrument.partial;

import com.cstav.genshinstrument.client.config.enumType.SoundType;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.GridInstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.InstrumentOptionsScreen;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.SingleButtonOptionsScreen;
import com.cstav.genshinstrument.client.util.TogglablePedalSound;
import com.cstav.genshinstrument.event.MidiEvent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5676;

@Environment(value=EnvType.CLIENT)
public abstract class SoundTypeOptionsScreen<T extends SoundType>
extends SingleButtonOptionsScreen {
    private T preferredSoundType = this.getInitSoundType();

    public SoundTypeOptionsScreen(GridInstrumentScreen screen) {
        super(screen);
    }

    public SoundTypeOptionsScreen(class_437 lastScreen) {
        super(lastScreen);
    }

    public T getPreferredSoundType() {
        return this.preferredSoundType;
    }

    public void setPreferredSoundType(T preferredSoundType) {
        this.preferredSoundType = preferredSoundType;
        if (this.instrumentScreen.map(this::isValidForSet).orElse(false).booleanValue()) {
            ((InstrumentScreen)((Object)this.instrumentScreen.get())).setNoteSounds(preferredSoundType.getSoundArr().get());
        }
    }

    protected abstract T getInitSoundType();

    protected abstract T[] values();

    protected abstract String soundTypeButtonKey();

    @Override
    protected class_4264 constructButton() {
        return class_5676.method_32606(soundType -> class_2561.method_43471((String)(this.soundTypeButtonKey() + "." + soundType.getName()))).method_32624((Object[])this.values()).method_32619(this.getPreferredSoundType()).method_32617(0, 0, this.getBigButtonWidth(), this.getButtonHeight(), (class_2561)class_2561.method_43471((String)this.soundTypeButtonKey()), this::onSoundTypeChange);
    }

    protected void onSoundTypeChange(class_5676<T> btn, T soundType) {
        this.setPreferredSoundType(soundType);
        this.instrumentScreen.ifPresent(screen -> this.queueToSave(screen.getInstrumentId().method_12832() + "_sound_type", () -> this.saveSoundType(soundType)));
    }

    protected abstract void saveSoundType(T var1);

    protected abstract boolean isValidForSet(InstrumentScreen var1);

    public TogglablePedalSound<T> midiPedalListener() {
        return null;
    }

    public static void onMidiReceivedEvent(MidiEvent.MidiEventArgs args) {
        InstrumentOptionsScreen instrumentOptionsScreen;
        InstrumentScreen instrumentScreen = InstrumentScreen.getCurrentScreen(class_310.method_1551()).orElse(null);
        if (instrumentScreen == null || !((instrumentOptionsScreen = instrumentScreen.optionsScreen) instanceof SoundTypeOptionsScreen)) {
            return;
        }
        SoundTypeOptionsScreen optionsScreen = (SoundTypeOptionsScreen)instrumentOptionsScreen;
        TogglablePedalSound pedalSounds = optionsScreen.midiPedalListener();
        if (optionsScreen.midiPedalListener() == null) {
            return;
        }
        byte[] message = args.message.getMessage();
        if (message[0] != -80 && message[0] != -176 || message[1] != 64) {
            return;
        }
        optionsScreen.setPreferredSoundType(message[2] >= 64 ? pedalSounds.enabled : pedalSounds.disabled);
    }
}

