/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.options.instrument;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.AbstractInstrumentOptionsScreen;
import com.cstav.genshinstrument.client.gui.widget.SliderButton;
import com.cstav.genshinstrument.client.midi.MidiController;
import com.cstav.genshinstrument.client.util.ClientUtil;
import com.cstav.genshinstrument.util.CommonUtil;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_7845;
import net.minecraft.class_7852;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8133;

@Environment(value=EnvType.CLIENT)
public class MidiOptionsScreen
extends AbstractInstrumentOptionsScreen {
    public static final int MIN_OCTAVE_SHIFT = -5;
    public static final int MAX_OCTAVE_SHIFT = 5;
    public static final int MIN_MIDI_CHANNEL = 0;
    public static final int MAX_MIDI_CHANNEL = 15;

    public MidiOptionsScreen(class_2561 pTitle, class_437 prevScreen, InstrumentScreen instrumentScreen) {
        super(pTitle, instrumentScreen, prevScreen);
    }

    public MidiOptionsScreen(class_2561 pTitle, class_437 prevScreen, Optional<InstrumentScreen> instrumentScreen) {
        super(pTitle, instrumentScreen, prevScreen);
    }

    protected void method_25426() {
        class_7845 grid = new class_7845();
        grid.method_46458().method_46465(4, 2).method_46468(0.5f).method_46467();
        this.initOptionsGrid(grid, grid.method_47610(2));
        ClientUtil.alignGrid((class_8133)grid, this.field_22789, this.field_22790);
        grid.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        class_4185 doneBtn = class_4185.method_46430((class_2561)class_5244.field_24334, btn -> this.method_25419()).method_46432(150).method_46433((this.field_22789 - 150) / 2, ClientUtil.lowerButtonsY(grid.method_46427(), grid.method_25364(), this.field_22790)).method_46431();
        this.method_37063((class_364)doneBtn);
    }

    protected void initDeviceSection(class_7845 grid, class_7845.class_7939 rowHelper) {
        class_5676 midiEnabled = class_5676.method_32607((class_2561)class_5244.field_24332, (class_2561)class_5244.field_24333).method_32619((Object)((Boolean)ModClientConfigs.MIDI_ENABLED.get())).method_32617(0, 0, this.getBigButtonWidth(), this.getButtonHeight(), (class_2561)class_2561.method_43471((String)"button.genshinstrument.midiEnabled"), this::onMidiEnabledChanged);
        rowHelper.method_47613((class_8021)midiEnabled, 2);
        SliderButton inputSensitivity = new SliderButton(this.getSmallButtonWidth(), (Double)ModClientConfigs.MIDI_IN_SENSITIVITY.get(), 0.0, 1.0){
            private static final DecimalFormat D_FORMAT = new DecimalFormat("0.0");

            @Override
            public class_2561 method_25369() {
                return class_2561.method_43471((String)"button.genshinstrument.inputSensitivity").method_27693(": " + D_FORMAT.format((Double)ModClientConfigs.MIDI_IN_SENSITIVITY.get() * 100.0) + "%");
            }

            protected void method_25344() {
                MidiOptionsScreen.this.onMidiSensitivityChanged(this, this.field_22753);
            }
        };
        class_5676 fixedTouch = class_5676.method_32607((class_2561)class_5244.field_24332, (class_2561)class_5244.field_24333).method_32619((Object)((Boolean)ModClientConfigs.FIXED_TOUCH.get())).method_32618(value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"button.genshinstrument.fixedTouch.tooltip"))).method_32617(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (class_2561)class_2561.method_43471((String)"button.genshinstrument.fixedTouch"), (btn, val) -> {
            this.onFixedTouchChanged((class_5676<Boolean>)btn, (boolean)val);
            inputSensitivity.field_22763 = val == false;
        });
        inputSensitivity.field_22763 = (Boolean)ModClientConfigs.FIXED_TOUCH.get() == false;
        rowHelper.method_47612((class_8021)fixedTouch);
        rowHelper.method_47612((class_8021)inputSensitivity);
        MidiController.reloadDevices();
        class_5676 midiDevice = class_5676.method_32606(value -> {
            if (value == -1) {
                return class_2561.method_43471((String)"button.none");
            }
            return class_2561.method_43470((String)MidiController.infoAsString(MidiController.getInfoFromIndex(value)));
        }).method_32620(MidiOptionsScreen.getMidiDevicesRange()).method_32619((Object)((Integer)ModClientConfigs.MIDI_DEVICE_INDEX.get())).method_32617(0, 0, this.getBigButtonWidth(), this.getButtonHeight(), (class_2561)class_2561.method_43471((String)"button.genshinstrument.midiDevice"), this::onMidiDeviceChanged);
        rowHelper.method_47613((class_8021)midiDevice, 2);
    }

    protected void initThatOtherSection(class_7845 grid, class_7845.class_7939 rowHelper) {
        boolean canInstrumentOverflow = this.instrumentScreen.map(screen -> screen.midiReceiver.allowMidiOverflow()).orElse(false);
        if (canInstrumentOverflow) {
            class_5676 extendOctaves = class_5676.method_32607((class_2561)class_5244.field_24332, (class_2561)class_5244.field_24333).method_32619((Object)((Boolean)ModClientConfigs.EXTEND_OCTAVES.get())).method_32618(value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"button.genshinstrument.extendOctaves.tooltip"))).method_32617(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (class_2561)class_2561.method_43471((String)"button.genshinstrument.extendOctaves"), this::onExtendOctavesChanged);
            rowHelper.method_47612((class_8021)extendOctaves);
        }
        SliderButton octaveShift = new SliderButton(canInstrumentOverflow ? this.getSmallButtonWidth() : this.getBigButtonWidth(), ((Integer)ModClientConfigs.OCTAVE_SHIFT.get()).intValue(), -5.0, 5.0){

            @Override
            public class_2561 method_25369() {
                return class_2561.method_43471((String)"button.genshinstrument.midiOctaveShift").method_27693(": " + ModClientConfigs.OCTAVE_SHIFT.get());
            }

            protected void method_25344() {
                MidiOptionsScreen.this.onOctaveShiftChanged(this, (int)this.getValueClamped());
            }
        };
        rowHelper.method_47613((class_8021)octaveShift, canInstrumentOverflow ? 1 : 2);
        SliderButton midiChannel = new SliderButton(this.getSmallButtonWidth(), ((Integer)ModClientConfigs.MIDI_CHANNEL.get()).intValue(), 0.0, 15.0){

            @Override
            public class_2561 method_25369() {
                return class_2561.method_43471((String)"button.genshinstrument.midiChannel").method_27693(": " + ModClientConfigs.MIDI_CHANNEL.get());
            }

            protected void method_25344() {
                MidiOptionsScreen.this.onMidiChannelChanged(this, (int)this.getValueClamped());
            }
        };
        class_5676 acceptAllChannels = class_5676.method_32607((class_2561)class_5244.field_24332, (class_2561)class_5244.field_24333).method_32619((Object)((Boolean)ModClientConfigs.ACCEPT_ALL_CHANNELS.get())).method_32617(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (class_2561)class_2561.method_43471((String)"button.genshinstrument.acceptAllChannels"), (btn, val) -> {
            this.onAcceptAllChannelsChanged((class_5676<Boolean>)btn, (boolean)val);
            midiChannel.field_22763 = val == false;
        });
        midiChannel.field_22763 = (Boolean)acceptAllChannels.method_32603() == false;
        rowHelper.method_47612((class_8021)acceptAllChannels);
        rowHelper.method_47612((class_8021)midiChannel);
    }

    protected void initOptionsGrid(class_7845 grid, class_7845.class_7939 rowHelper) {
        this.initDeviceSection(grid, rowHelper);
        rowHelper.method_47613((class_8021)class_7852.method_46513((int)7), 2);
        this.initThatOtherSection(grid, rowHelper);
    }

    public static List<Integer> getMidiDevicesRange() {
        return IntStream.range(-1, MidiController.DEVICES.size()).boxed().toList();
    }

    protected void onMidiEnabledChanged(class_5676<Boolean> button, boolean value) {
        ModClientConfigs.MIDI_ENABLED.set((Object)value);
        MidiController.loadByConfigs();
    }

    protected void onMidiDeviceChanged(class_5676<Integer> button, int value) {
        ModClientConfigs.MIDI_DEVICE_INDEX.set((Object)value);
        MidiController.loadByConfigs();
    }

    protected void onExtendOctavesChanged(class_5676<Boolean> button, boolean value) {
        ModClientConfigs.EXTEND_OCTAVES.set((Object)value);
    }

    protected void onOctaveShiftChanged(class_357 button, int value) {
        if ((Integer)ModClientConfigs.OCTAVE_SHIFT.get() != value) {
            ModClientConfigs.OCTAVE_SHIFT.set((Object)value);
        }
    }

    protected void onFixedTouchChanged(class_5676<Boolean> button, boolean value) {
        ModClientConfigs.FIXED_TOUCH.set((Object)value);
    }

    protected void onMidiSensitivityChanged(class_357 button, double value) {
        value = CommonUtil.round(value, 3);
        if ((Double)ModClientConfigs.MIDI_IN_SENSITIVITY.get() != value) {
            ModClientConfigs.MIDI_IN_SENSITIVITY.set((Object)value);
        }
    }

    protected void onAcceptAllChannelsChanged(class_5676<Boolean> button, boolean value) {
        ModClientConfigs.ACCEPT_ALL_CHANNELS.set((Object)value);
    }

    protected void onMidiChannelChanged(class_357 button, int value) {
        if ((Integer)ModClientConfigs.MIDI_CHANNEL.get() != value) {
            ModClientConfigs.MIDI_CHANNEL.set((Object)value);
        }
    }
}

