/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.ukulele;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.GridInstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.NoteGrid;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.grid.NoteGridButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.ukulele.Ukulele3rdOctaveType;
import com.cstav.genshinstrument.client.gui.screen.instrument.ukulele.UkuleleMidiReceiver;
import com.cstav.genshinstrument.client.gui.screen.instrument.ukulele.UkuleleNoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.ukulele.UkuleleOptionsScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.ukulele.UkuleleThemeLoader;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.InstrumentOptionsScreen;
import com.cstav.genshinstrument.client.midi.InstrumentMidiReceiver;
import com.cstav.genshinstrument.sound.GISounds;
import com.cstav.genshinstrument.sound.NoteSound;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class UkuleleScreen
extends GridInstrumentScreen {
    public static final class_2960 INSTRUMENT_ID = new class_2960("genshinstrument", "ukulele");
    private static final String[] NOTE_LAYOUT = new String[]{"C", "Dm", "Em", "F", "G", "Am", "G7", "C", "D", "E", "F", "G", "A", "B", "C", "D", "E", "F", "G", "A", "B"};
    public Ukulele3rdOctaveType octaveType = (Ukulele3rdOctaveType)((Object)ModClientConfigs.UKULELE_3RD_OCTAVE_TYPE.get());
    public static final UkuleleThemeLoader THEME_LOADER = new UkuleleThemeLoader(INSTRUMENT_ID);

    @Override
    public class_2960 getInstrumentId() {
        return INSTRUMENT_ID;
    }

    @Override
    public String[] noteLayout() {
        return NOTE_LAYOUT;
    }

    @Override
    public NoteSound[] getInitSounds() {
        return GISounds.UKULELE;
    }

    public boolean isTopRegular() {
        return this.octaveType == Ukulele3rdOctaveType.TREBLE;
    }

    @Override
    public NoteGridButton createNote(int row, int column) {
        return new UkuleleNoteButton(row, column, this);
    }

    @Override
    protected InstrumentOptionsScreen initInstrumentOptionsScreen() {
        return new UkuleleOptionsScreen(this);
    }

    @Override
    public UkuleleThemeLoader getThemeLoader() {
        return THEME_LOADER;
    }

    @Override
    public InstrumentMidiReceiver initMidiReceiver() {
        return new UkuleleMidiReceiver(this);
    }

    @Override
    protected void renderClef(class_332 gui, int index, int x, String clefName) {
        if (this.isTopRegular()) {
            super.renderClef(gui, index, x, clefName);
            return;
        }
        switch (index) {
            case 0: {
                this.renderClefChord(gui, index, x);
                break;
            }
            case 1: {
                super.renderClef(gui, index, x, "treble");
                break;
            }
            case 2: {
                super.renderClef(gui, index, x, "alto");
            }
        }
    }

    private void renderClefChord(class_332 gui, int index, int x) {
        RenderSystem.enableBlend();
        gui.method_25290(this.getResourceFromRoot("background/clef/chord.png"), x, this.grid.method_46427() + NoteGrid.getPaddingVert() + this.getLayerAddition(index) - 5, 0.0f, 0.0f, 26, 52, 26, 52);
        RenderSystem.disableBlend();
    }
}

