/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.grid;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.GridInstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.NoteGrid;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButtonRenderer;
import com.cstav.genshinstrument.client.keyMaps.InstrumentKeyMappings;
import com.cstav.genshinstrument.networking.buttonidentifier.NoteGridButtonIdentifier;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.util.LabelUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public class NoteGridButton
extends NoteButton {
    private static final class_2960[] GRID_LABELS = new class_2960[LabelUtil.ABC.length];
    public final int row;
    public final int column;

    public NoteGridButton(int row, int column, GridInstrumentScreen instrumentScreen) {
        super(NoteGridButton.getSoundFromArr(instrumentScreen, instrumentScreen.getInitSounds(), row, column), GridInstrumentScreen.getInitLabelSupplier(), instrumentScreen);
        this.row = row;
        this.column = column;
    }

    public NoteGridButton(int row, int column, GridInstrumentScreen instrumentScreen, int pitch) {
        super(instrumentScreen.getInitSounds()[0], instrumentScreen.getInitLabelSupplier(), instrumentScreen, pitch);
        this.row = row;
        this.column = column;
    }

    public GridInstrumentScreen gridInstrument() {
        return (GridInstrumentScreen)this.instrumentScreen;
    }

    public void updateSoundArr() {
        NoteGrid grid = this.gridInstrument().noteGrid;
        NoteSound[] sounds = grid.getNoteSounds();
        this.setSound(this.gridInstrument().isSSTI() ? sounds[0] : sounds[this.posToIndex()]);
    }

    public int posToIndex() {
        return this.row + NoteGrid.getFlippedColumn(this.column, this.gridInstrument().columns()) * this.gridInstrument().rows();
    }

    protected static NoteSound getSoundFromArr(GridInstrumentScreen gridInstrument, NoteSound[] sounds, int row, int column) {
        return sounds[row + NoteGrid.getFlippedColumn(column, gridInstrument.columns()) * gridInstrument.rows()];
    }

    public class_3675.class_306 getKey() {
        return InstrumentKeyMappings.GRID_INSTRUMENT_MAPPINGS[this.column][this.row];
    }

    @Override
    public NoteGridButtonIdentifier getIdentifier() {
        return new NoteGridButtonIdentifier(this);
    }

    @Override
    protected NoteButtonRenderer initNoteRenderer() {
        return new NoteButtonRenderer(this, this::getLabelTexture);
    }

    protected int getLabelTextureRow() {
        return (Boolean)ModClientConfigs.ACCURATE_NOTES.get() != false ? this.getABCOffset() : this.row % GRID_LABELS.length;
    }

    protected class_2960 getLabelTextureAt(int row) {
        return GRID_LABELS[row];
    }

    protected class_2960 getLabelTexture() {
        return this.getLabelTextureAt(this.getLabelTextureRow());
    }

    @Override
    public int getNoteOffset() {
        return this.row + this.column * this.gridInstrument().rows();
    }

    static {
        for (int i = 0; i < LabelUtil.ABC.length; ++i) {
            NoteGridButton.GRID_LABELS[i] = InstrumentScreen.getInternalResourceFromGlob("note/label/grid/" + Character.toLowerCase(LabelUtil.ABC[i]) + ".png");
        }
    }
}

