/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public abstract class AnimationController {
    protected final class_310 minecraft = class_310.method_1551();
    protected int animTime;
    private boolean isPlaying;
    public final double initDuration;
    public final double initTargetValue;
    protected double duration;
    protected double targetValue;

    public AnimationController(double duration, double targetValue) {
        this.duration = this.initDuration = duration;
        this.targetValue = this.initTargetValue = targetValue;
    }

    public int getAnimTime() {
        return this.animTime;
    }

    public void update() {
        if (!this.isPlaying()) {
            return;
        }
        int fps = this.minecraft.method_47599();
        double targetTime = (double)fps * this.duration;
        int n = this.animTime++;
        if ((double)n >= targetTime) {
            this.stop();
            return;
        }
        this.animFrame(targetTime, this.targetValue / targetTime);
    }

    protected abstract void animFrame(double var1, double var3);

    public void stop() {
        this.resetAnimVars();
        this.isPlaying = false;
    }

    public void play() {
        this.resetAnimVars();
        this.isPlaying = true;
    }

    public void play(double duration, double targetValue) {
        this.duration = duration;
        this.targetValue = targetValue;
    }

    protected void resetAnimVars() {
        this.duration = this.initDuration;
        this.targetValue = this.initTargetValue;
        this.animTime = 0;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }
}

