/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.satisfy.meadow.core.registry.RecipeRegistry;
import net.satisfy.meadow.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class CookingCauldronRecipe
implements class_1860<class_1263> {
    final class_2960 id;
    private final class_2371<class_1856> inputs;
    private final class_1799 output;
    private final int fluidAmount;
    private final int craftingDuration;

    public CookingCauldronRecipe(class_2960 id, class_2371<class_1856> inputs, class_1799 output, int fluidAmount, int craftingDuration) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
        this.fluidAmount = fluidAmount;
        this.craftingDuration = craftingDuration;
    }

    public boolean method_8115(class_1263 inventory, class_1937 world) {
        return GeneralUtil.matchesRecipe(inventory, this.inputs, 0, 6);
    }

    public class_1799 assemble() {
        return this.method_8116(null, null);
    }

    @NotNull
    public class_1799 method_8116(class_1263 inventory, class_5455 registryManager) {
        return this.output.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    public class_1799 getResultItem() {
        return this.method_8110(null);
    }

    @NotNull
    public class_1799 method_8110(class_5455 registryManager) {
        return this.output;
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public int getCraftingDuration() {
        return this.craftingDuration;
    }

    @NotNull
    public class_2960 method_8114() {
        return this.id;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return (class_1865)RecipeRegistry.COOKING_SERIALIZER.get();
    }

    @NotNull
    public class_3956<?> method_17716() {
        return (class_3956)RecipeRegistry.COOKING.get();
    }

    @NotNull
    public class_2371<class_1856> method_8117() {
        return this.inputs;
    }

    public boolean method_8118() {
        return true;
    }

    public static class Type
    implements class_3956<CookingCauldronRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "cooking";

        private Type() {
        }
    }

    public static class Serializer
    implements class_1865<CookingCauldronRecipe> {
        @NotNull
        public CookingCauldronRecipe fromJson(class_2960 id, JsonObject json) {
            class_2371<class_1856> ingredients = GeneralUtil.deserializeIngredients(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for CookingCauldron Recipe");
            }
            if (ingredients.size() > 6) {
                throw new JsonParseException("Too many ingredients for CookingCauldron Recipe");
            }
            int fluidAmount = class_3518.method_15282((JsonObject)json, (String)"fluid_amount", (int)0);
            int craftingDuration = class_3518.method_15282((JsonObject)json, (String)"crafting_duration", (int)10);
            return new CookingCauldronRecipe(id, ingredients, class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result")), fluidAmount, craftingDuration);
        }

        @NotNull
        public CookingCauldronRecipe fromNetwork(class_2960 id, class_2540 buf) {
            class_2371 ingredients = class_2371.method_10213((int)buf.method_10816(), (Object)class_1856.field_9017);
            ingredients.replaceAll(ignored -> class_1856.method_8086((class_2540)buf));
            class_1799 output = buf.method_10819();
            int fluidAmount = buf.readInt();
            int craftingDuration = buf.readInt();
            return new CookingCauldronRecipe(id, (class_2371<class_1856>)ingredients, output, fluidAmount, craftingDuration);
        }

        public void toNetwork(class_2540 buf, CookingCauldronRecipe recipe) {
            buf.method_10804(recipe.inputs.size());
            recipe.inputs.forEach(entry -> entry.method_8088(buf));
            buf.method_10793(recipe.output);
            buf.writeInt(recipe.fluidAmount);
            buf.writeInt(recipe.craftingDuration);
        }
    }
}

