/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.entity;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3542;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7995;
import net.satisfy.meadow.core.registry.TagRegistry;
import org.jetbrains.annotations.NotNull;

public enum WoolySheepVar implements class_3542
{
    FLECKED(0, "flecked_sheep", new float[]{1.0f, 1.0f, 1.0f}),
    PATCHED(1, "patched_sheep", new float[]{0.8f, 0.8f, 0.8f}),
    ROCKY(2, "rocky_sheep", new float[]{0.6f, 0.6f, 0.6f}),
    INKY(3, "inky_sheep", new float[]{0.2f, 0.2f, 0.2f}),
    FUZZY(4, "fuzzy_sheep", new float[]{0.9f, 0.7f, 0.5f}),
    LONG_NOSED(5, "long_nosed_sheep", new float[]{0.7f, 0.5f, 0.3f});

    public static final Codec<WoolySheepVar> CODEC;
    private static final IntFunction<WoolySheepVar> BY_ID;
    private final int id;
    private final String name;
    private final float[] textureDiffuseColors;
    private static final Map<WoolySheepVar, class_6862<class_1959>> SPAWNS;

    private WoolySheepVar(int id, String name, float[] textureDiffuseColors) {
        this.id = id;
        this.name = name;
        this.textureDiffuseColors = textureDiffuseColors;
    }

    public int getId() {
        return this.id;
    }

    public static WoolySheepVar byId(int i) {
        return BY_ID.apply(i);
    }

    @NotNull
    public String method_15434() {
        return this.name;
    }

    public static WoolySheepVar getRandomVariant(class_1936 levelAccessor, class_2338 blockPos, boolean spawnEgg) {
        class_6880 holder = levelAccessor.method_23753(blockPos);
        class_5819 random = levelAccessor.method_8409();
        List<WoolySheepVar> possibleVars = WoolySheepVar.getShearableSheepVariantsInBiome((class_6880<class_1959>)holder);
        int size = possibleVars.size();
        if (size == 0 || spawnEgg) {
            if (spawnEgg) {
                return (WoolySheepVar)((Object)class_156.method_27173((Object[])WoolySheepVar.values(), (class_5819)random));
            }
            if (holder.method_40220(TagRegistry.IS_MEADOW)) {
                return FLECKED;
            }
            ArrayList<WoolySheepVar> list = new ArrayList<WoolySheepVar>(List.of(WoolySheepVar.values()));
            return (WoolySheepVar)((Object)class_156.method_32309(list, (class_5819)random));
        }
        return possibleVars.get(random.method_43048(size));
    }

    private static List<WoolySheepVar> getShearableSheepVariantsInBiome(class_6880<class_1959> biome) {
        return SPAWNS.keySet().stream().filter(variant -> biome.method_40220(SPAWNS.get(variant))).collect(Collectors.toList());
    }

    public float[] getTextureDiffuseColors() {
        return this.textureDiffuseColors;
    }

    static {
        CODEC = class_3542.method_28140(WoolySheepVar::values);
        BY_ID = class_7995.method_47914(WoolySheepVar::getId, (Object[])WoolySheepVar.values(), (class_7995.class_7996)class_7995.class_7996.field_41665);
        SPAWNS = (Map)class_156.method_654(new HashMap(), map -> {
            map.put(FLECKED, TagRegistry.IS_MEADOW);
            map.put(PATCHED, class_6908.field_36517);
            map.put(ROCKY, TagRegistry.SPAWNS_ROCKY_SHEEP);
            map.put(INKY, class_6908.field_37392);
            map.put(FUZZY, class_6908.field_36517);
            map.put(LONG_NOSED, class_6908.field_36512);
        });
    }
}

