/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.entity;

import java.util.Objects;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1345;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5147;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.satisfy.meadow.core.entity.WoolySheepVar;
import net.satisfy.meadow.core.registry.EntityTypeRegistry;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.TagRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoolySheepEntity
extends class_1429
implements class_5147 {
    private static final class_2940<Byte> DATA_WOOL_TYPE = class_2945.method_12791(WoolySheepEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Integer> DATA_ID_TYPE_VARIANT = class_2945.method_12791(WoolySheepEntity.class, (class_2941)class_2943.field_13327);
    private class_1345 eatBlockGoal;
    private int eatAnimationTick;

    public WoolySheepEntity(class_1299<? extends class_1429> type, class_1937 level) {
        super(type, level);
        this.setWoolType((byte)0);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, (double)0.23f);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_WOOL_TYPE, (Object)0);
        this.field_6011.method_12784(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public void method_5652(class_2487 c) {
        super.method_5652(c);
        c.method_10556("Sheared", this.isSheared());
        c.method_10567("WoolType", this.getWoolType());
        c.method_10569("Variant", this.getTypeVariant());
    }

    public void method_5749(class_2487 c) {
        super.method_5749(c);
        this.setSheared(c.method_10577("Sheared"));
        this.setWoolType(c.method_10571("WoolType"));
        this.setTypeVariant(c.method_10550("Variant"));
    }

    protected void method_5959() {
        this.eatBlockGoal = new class_1345((class_1308)this);
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.1, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8861}), false));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(5, (class_1352)this.eatBlockGoal);
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
    }

    public void method_6007() {
        if (this.method_37908().field_9236) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.method_6007();
    }

    public void method_5958() {
        this.eatAnimationTick = this.eatBlockGoal.method_6258();
        super.method_5958();
    }

    public void method_5983() {
        super.method_5983();
        this.setSheared(false);
    }

    public void method_5711(byte b) {
        if (b == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.method_5711(b);
        }
    }

    public float getHeadEatPositionScale(float f) {
        if (this.eatAnimationTick <= 0) {
            return 0.0f;
        }
        if (this.eatAnimationTick >= 4 && this.eatAnimationTick <= 36) {
            return 1.0f;
        }
        return this.eatAnimationTick < 4 ? ((float)this.eatAnimationTick - f) / 4.0f : -((float)(this.eatAnimationTick - 40) - f) / 4.0f;
    }

    public float getHeadEatAngleScale(float f) {
        if (this.eatAnimationTick > 4 && this.eatAnimationTick <= 36) {
            float g = ((float)(this.eatAnimationTick - 4) - f) / 32.0f;
            return 0.62831855f + 0.21991149f * class_3532.method_15374((float)(g * 28.7f));
        }
        return this.eatAnimationTick > 0 ? 0.62831855f : this.method_36455() * ((float)Math.PI / 180);
    }

    @NotNull
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_31573(TagRegistry.SHEARS)) {
            if (!this.method_37908().field_9236 && this.method_27072()) {
                this.method_6636(class_3419.field_15248);
                this.method_32875(class_5712.field_28730, (class_1297)player);
                stack.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        return super.method_5992(player, hand);
    }

    public void method_6636(class_3419 source) {
        if (!this.method_37908().field_9236 && this.method_27072()) {
            this.method_37908().method_43129(null, (class_1297)this, class_3417.field_14975, source, 1.0f, 1.0f);
            this.setSheared(true);
            WoolySheepVar variant = this.getVariant();
            int count = 1 + this.field_5974.method_43048(3);
            for (int i = 0; i < count; ++i) {
                class_1792 woolItem = WoolySheepEntity.getWoolItemByVariant(variant);
                class_1799 woolStack = new class_1799((class_1935)woolItem);
                class_1542 itemEntity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318() + 1.0, this.method_23321(), woolStack);
                itemEntity.method_18799(itemEntity.method_18798().method_1031((double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f), (double)(this.field_5974.method_43057() * 0.05f), (double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f)));
                this.method_37908().method_8649((class_1297)itemEntity);
            }
        }
    }

    public static class_1792 getWoolItemByVariant(WoolySheepVar variant) {
        return switch (variant) {
            default -> throw new IncompatibleClassChangeError();
            case WoolySheepVar.FLECKED -> ((class_2248)ObjectRegistry.FLECKED_WOOL.get()).method_8389();
            case WoolySheepVar.PATCHED -> ((class_2248)ObjectRegistry.PATCHED_WOOL.get()).method_8389();
            case WoolySheepVar.ROCKY -> ((class_2248)ObjectRegistry.ROCKY_WOOL.get()).method_8389();
            case WoolySheepVar.INKY -> ((class_2248)ObjectRegistry.INKY_WOOL.get()).method_8389();
            case WoolySheepVar.FUZZY -> class_1802.field_19044;
            case WoolySheepVar.LONG_NOSED -> ((class_2248)ObjectRegistry.HIGHLAND_WOOL.get()).method_8389();
        };
    }

    @Nullable
    public WoolySheepEntity getBreedOffspring(class_3218 level, class_1296 mob) {
        WoolySheepEntity sheep = (WoolySheepEntity)((class_1299)EntityTypeRegistry.WOOLY_SHEEP.get()).method_5883((class_1937)level);
        if (sheep != null) {
            class_5819 random = level.method_8409();
            WoolySheepVar var = this.getVariant();
            if (random.method_43056() && mob instanceof WoolySheepEntity) {
                WoolySheepEntity varSheep = (WoolySheepEntity)mob;
                var = varSheep.getVariant();
            }
            sheep.setVariant(var);
        }
        return sheep;
    }

    @NotNull
    public class_1315 method_5943(class_5425 levelAccessor, class_1266 difficultyInstance, class_3730 mobSpawnType, @Nullable class_1315 spawnGroupData, @Nullable class_2487 compoundTag) {
        WoolySheepVar variant;
        if (spawnGroupData instanceof ShearableVarSheepGroupData) {
            ShearableVarSheepGroupData data = (ShearableVarSheepGroupData)((Object)spawnGroupData);
            variant = data.variant;
        } else {
            variant = WoolySheepVar.getRandomVariant((class_1936)levelAccessor, this.method_24515(), mobSpawnType.equals((Object)class_3730.field_16465));
            spawnGroupData = new ShearableVarSheepGroupData(variant);
        }
        this.setVariant(variant);
        return Objects.requireNonNull(super.method_5943(levelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag));
    }

    public void setVariant(WoolySheepVar variant) {
        this.setTypeVariant(variant.getId() & 0xFF | this.getTypeVariant() & 0xFFFFFF00);
    }

    @NotNull
    public WoolySheepVar getVariant() {
        return WoolySheepVar.byId(this.getTypeVariant() & 0xFF);
    }

    private void setTypeVariant(int i) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)i);
    }

    private int getTypeVariant() {
        return (Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT);
    }

    public byte getWoolType() {
        return (byte)((Byte)this.field_6011.method_12789(DATA_WOOL_TYPE) & 0xF);
    }

    public void setWoolType(byte woolType) {
        this.field_6011.method_12778(DATA_WOOL_TYPE, (Object)woolType);
    }

    public boolean isSheared() {
        return ((Byte)this.field_6011.method_12789(DATA_WOOL_TYPE) & 0x10) != 0;
    }

    public void setSheared(boolean bl) {
        byte b = (Byte)this.field_6011.method_12789(DATA_WOOL_TYPE);
        if (bl) {
            this.field_6011.method_12778(DATA_WOOL_TYPE, (Object)((byte)(b | 0x10)));
        } else {
            this.field_6011.method_12778(DATA_WOOL_TYPE, (Object)((byte)(b & 0xFFFFFFEF)));
        }
    }

    protected class_3414 method_5994() {
        return class_3417.field_14603;
    }

    protected void method_5712(class_2338 blockPos, class_2680 blockState) {
        this.method_5783(class_3417.field_14870, 0.15f, 1.0f);
    }

    protected class_3414 method_6011(@NotNull class_1282 damageSource) {
        return class_3417.field_14730;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14814;
    }

    public boolean method_27072() {
        return this.method_5805() && !this.isSheared() && !this.method_6109();
    }

    public static class ShearableVarSheepGroupData
    extends class_1296.class_4697 {
        public final WoolySheepVar variant;

        public ShearableVarSheepGroupData(WoolySheepVar variant) {
            super(true);
            this.variant = variant;
        }
    }
}

