/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.entity;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3542;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7995;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.TagRegistry;
import org.jetbrains.annotations.NotNull;

public enum WoolyCowVar implements class_3542
{
    HIGHLAND(0, "highland_cattle", ((class_2248)ObjectRegistry.HIGHLAND_WOOL.get()).method_8389(), (class_1792)ObjectRegistry.WOODEN_MILK_BUCKET.get()),
    UMBRA(1, "umbra_cow", ((class_2248)ObjectRegistry.UMBRA_WOOL.get()).method_8389(), (class_1792)ObjectRegistry.WOODEN_MILK_BUCKET.get()),
    WARPED(2, "warped_cow", ((class_2248)ObjectRegistry.WARPED_WOOL.get()).method_8389(), (class_1792)ObjectRegistry.WOODEN_WARPED_MILK_BUCKET.get());

    public static final Codec<WoolyCowVar> CODEC;
    private static final IntFunction<WoolyCowVar> BY_ID;
    private final int id;
    private final String name;
    private final class_1792 wool;
    private final class_1792 bucket;
    private static final Map<WoolyCowVar, class_6862<class_1959>> SPAWNS;

    private WoolyCowVar(int id, String name, class_1792 wool, class_1792 bucket) {
        this.id = id;
        this.name = name;
        this.wool = wool;
        this.bucket = bucket;
    }

    public class_1792 getWool() {
        return this.wool;
    }

    public class_1792 getBucket() {
        return this.bucket;
    }

    public int getId() {
        return this.id;
    }

    public static WoolyCowVar byId(int i) {
        return BY_ID.apply(i);
    }

    @NotNull
    public String method_15434() {
        return this.name;
    }

    public static WoolyCowVar getRandomVariant(class_1936 levelAccessor, class_2338 blockPos, boolean spawnEgg) {
        class_6880 holder = levelAccessor.method_23753(blockPos);
        class_5819 random = levelAccessor.method_8409();
        List<WoolyCowVar> possibleVars = WoolyCowVar.getShearableCowVariantsInBiome((class_6880<class_1959>)holder);
        int size = possibleVars.size();
        if (size == 0 || spawnEgg) {
            if (spawnEgg) {
                return (WoolyCowVar)((Object)class_156.method_27173((Object[])WoolyCowVar.values(), (class_5819)random));
            }
            if (holder.method_40220(class_6908.field_36518)) {
                return WARPED;
            }
            ArrayList<WoolyCowVar> list = new ArrayList<WoolyCowVar>(List.of(WoolyCowVar.values()));
            list.remove((Object)WARPED);
            return (WoolyCowVar)((Object)class_156.method_32309(list, (class_5819)random));
        }
        return possibleVars.get(levelAccessor.method_8409().method_43048(size));
    }

    private static List<WoolyCowVar> getShearableCowVariantsInBiome(class_6880<class_1959> biome) {
        return SPAWNS.keySet().stream().filter(ShearableCowVariant -> biome.method_40220(SPAWNS.get(ShearableCowVariant))).collect(Collectors.toList());
    }

    static {
        CODEC = class_3542.method_28140(WoolyCowVar::values);
        BY_ID = class_7995.method_47914(WoolyCowVar::getId, (Object[])WoolyCowVar.values(), (class_7995.class_7996)class_7995.class_7996.field_41665);
        SPAWNS = (Map)class_156.method_654(new HashMap(), map -> {
            map.put(HIGHLAND, TagRegistry.IS_MEADOW);
            map.put(UMBRA, TagRegistry.SPAWNS_UMBRA_COW);
            map.put(WARPED, TagRegistry.SPAWNS_WARPED_COW);
        });
    }
}

