/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.entity;

import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1345;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5147;
import net.minecraft.class_5328;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.class_7988;
import net.satisfy.meadow.core.entity.WoolyCowVar;
import net.satisfy.meadow.core.registry.EntityTypeRegistry;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.util.MeadowIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoolyCowEntity
extends class_1429
implements class_5147,
class_7988<WoolyCowVar> {
    private static final class_2940<Boolean> IS_SHEARED = class_2945.method_12791(WoolyCowEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DATA_ID_TYPE_VARIANT = class_2945.method_12791(WoolyCowEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2960 COW_LOOT_TABLE = new class_2960("entities/cow");
    private int eatGrassTimer;
    private class_1345 eatGrassGoal;

    public WoolyCowEntity(class_1299<WoolyCowEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    @NotNull
    protected class_2960 method_5991() {
        if (this.isSheared()) {
            return COW_LOOT_TABLE;
        }
        class_2960 location = class_7923.field_41178.method_10221((Object)this.getVariant().getWool());
        String s = location.method_12832().replace("_wool", "");
        return new MeadowIdentifier("entities/wooly_cow/" + s);
    }

    @NotNull
    public class_1269 method_5992(class_1657 player, @NotNull class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_8868)) {
            if (!this.method_37908().field_9236 && this.method_27072()) {
                this.method_6636(class_3419.field_15248);
                this.method_32875(class_5712.field_28730, (class_1297)player);
                itemStack.method_7956(1, (class_1309)player, player2 -> player2.method_20236(hand));
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        if (itemStack.method_31574((class_1792)ObjectRegistry.WOODEN_BUCKET.get()) && !this.method_6109()) {
            player.method_5783(class_3417.field_14691, 1.0f, 1.0f);
            class_1799 itemStack2 = class_5328.method_30012((class_1799)itemStack, (class_1657)player, (class_1799)this.getVariant().getBucket().method_7854());
            player.method_6122(hand, itemStack2);
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    public void method_6636(@NotNull class_3419 shearedSoundCategory) {
        this.method_37908().method_43129(null, (class_1297)this, class_3417.field_14975, shearedSoundCategory, 1.0f, 1.0f);
        this.setSheared(true);
        int i = 1 + this.field_5974.method_43048(3);
        for (int j = 0; j < i; ++j) {
            class_1542 itemEntity = this.method_5870((class_1935)this.getVariant().getWool(), 1);
            if (itemEntity == null) continue;
            itemEntity.method_18799(itemEntity.method_18798().method_1031((double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f), (double)(this.field_5974.method_43057() * 0.05f), (double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f)));
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Sheared", this.isSheared());
        nbt.method_10569("Variant", this.getTypeVariant());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setSheared(nbt.method_10577("Sheared"));
        this.setTypeVariant(nbt.method_10550("Variant"));
    }

    public void method_5983() {
        super.method_5983();
        this.setSheared(false);
        if (this.method_6109()) {
            this.method_5615(60);
        }
    }

    protected void method_5958() {
        this.eatGrassTimer = this.eatGrassGoal.method_6258();
        super.method_5958();
    }

    public void method_6007() {
        if (this.method_37908().field_9236) {
            this.eatGrassTimer = Math.max(0, this.eatGrassTimer - 1);
        }
        super.method_6007();
    }

    public void setSheared(boolean sheared) {
        this.field_6011.method_12778(IS_SHEARED, (Object)sheared);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(IS_SHEARED, (Object)false);
        this.field_6011.method_12784(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public boolean isSheared() {
        return (Boolean)this.field_6011.method_12789(IS_SHEARED);
    }

    public boolean method_27072() {
        return this.method_5805() && !this.isSheared() && !this.method_6109();
    }

    public void method_5711(byte status) {
        if (status == 10) {
            this.eatGrassTimer = 40;
        } else {
            super.method_5711(status);
        }
    }

    public float getNeckAngle(float delta) {
        if (this.eatGrassTimer <= 0) {
            return 0.0f;
        }
        if (this.eatGrassTimer >= 4 && this.eatGrassTimer <= 36) {
            return 1.0f;
        }
        if (this.eatGrassTimer < 4) {
            return ((float)this.eatGrassTimer - delta) / 4.0f;
        }
        return -((float)(this.eatGrassTimer - 40) - delta) / 4.0f;
    }

    public float getHeadAngle(float delta) {
        if (this.eatGrassTimer > 4 && this.eatGrassTimer <= 36) {
            float f = ((float)(this.eatGrassTimer - 4) - delta) / 32.0f;
            return 0.62831855f + 0.21991149f * class_3532.method_15374((float)(f * 28.7f));
        }
        if (this.eatGrassTimer > 0) {
            return 0.62831855f;
        }
        return this.method_36455() * ((float)Math.PI / 180);
    }

    @Nullable
    public WoolyCowEntity getBreedOffspring(@NotNull class_3218 serverLevel, @NotNull class_1296 ageableMob) {
        WoolyCowEntity cow = (WoolyCowEntity)((class_1299)EntityTypeRegistry.WOOLY_COW.get()).method_5883((class_1937)serverLevel);
        if (cow == null) {
            return null;
        }
        class_5819 random = serverLevel.method_8409();
        WoolyCowVar var = this.getVariant();
        if (random.method_43056() && ageableMob instanceof WoolyCowEntity) {
            WoolyCowEntity varCow = (WoolyCowEntity)ageableMob;
            var = varCow.getVariant();
        }
        cow.setVariant(var);
        return cow;
    }

    @Nullable
    public class_1315 method_5943(@NotNull class_5425 serverLevelAccessor, @NotNull class_1266 difficultyInstance, @NotNull class_3730 mobSpawnType, @Nullable class_1315 spawnGroupData, @Nullable class_2487 compoundTag) {
        WoolyCowVar variant;
        if (spawnGroupData instanceof ShearableVarCowGroupData) {
            ShearableVarCowGroupData data = (ShearableVarCowGroupData)((Object)spawnGroupData);
            variant = data.variant;
        } else {
            variant = WoolyCowVar.getRandomVariant((class_1936)serverLevelAccessor, this.method_24515(), mobSpawnType.equals((Object)class_3730.field_16465));
            spawnGroupData = new ShearableVarCowGroupData(variant);
        }
        this.setVariant(variant);
        return super.method_5943(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public void setVariant(WoolyCowVar variant) {
        this.setTypeVariant(variant.getId() & 0xFF | this.getTypeVariant() & 0xFFFFFF00);
    }

    @NotNull
    public WoolyCowVar getVariant() {
        return WoolyCowVar.byId(this.getTypeVariant() & 0xFF);
    }

    private void setTypeVariant(int i) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)i);
    }

    private int getTypeVariant() {
        return (Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 2.0));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.25, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8861}), false));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.25));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.eatGrassGoal = new class_1345((class_1308)this);
        this.field_6201.method_6277(5, (class_1352)this.eatGrassGoal);
    }

    protected class_3414 method_5994() {
        return class_3417.field_14780;
    }

    protected class_3414 method_6011(@NotNull class_1282 damageSource) {
        return class_3417.field_14597;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14857;
    }

    protected void method_5712(@NotNull class_2338 blockPos, @NotNull class_2680 blockState) {
        this.method_5783(class_3417.field_15110, 0.15f, 1.0f);
    }

    protected float method_6107() {
        return 0.4f;
    }

    protected float method_18394(@NotNull class_4050 pose, @NotNull class_4048 entityDimensions) {
        return this.method_6109() ? entityDimensions.field_18068 * 0.95f : 1.3f;
    }

    public static class ShearableVarCowGroupData
    extends class_1296.class_4697 {
        public final WoolyCowVar variant;

        public ShearableVarCowGroupData(WoolyCowVar variant) {
            super(true);
            this.variant = variant;
        }
    }
}

