/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import com.google.common.base.Suppliers;
import com.google.common.collect.ArrayListMultimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.every_compat.api.TextureInfo;
import net.mehvahdjukaar.every_compat.configs.ModEntriesConfigs;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.ColoringUtils;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.every_compat.misc.SpriteHelper;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSimpleEntrySet<T extends BlockType, B extends Block, I extends Item>
implements EntrySet<T> {
    protected static final ResourceLocation NO_TAB_MARKER = new ResourceLocation("none");
    public final Map<T, B> blocks = new HashMap<T, B>();
    public final Map<T, I> items = new HashMap<T, I>();
    protected final Class<T> type;
    protected final Pattern nameScheme;
    protected final Supplier<T> baseType;
    public final String typeName;
    public final String postfix;
    @Nullable
    public final String prefix;
    protected final boolean mergePalette;
    protected final Supplier<ResourceKey<CreativeModeTab>> tab;
    protected final TabAddMode tabMode;
    protected final Map<ResourceLocation, Set<ResourceKey<?>>> tags = new HashMap();
    protected final Set<Supplier<ResourceLocation>> recipeLocations = new HashSet<Supplier<ResourceLocation>>();
    protected final Set<TextureInfo> textures = new HashSet<TextureInfo>();
    protected final BiFunction<T, ResourceManager, Pair<List<Palette>, @Nullable McMetaFile>> paletteSupplier;
    @Nullable
    protected final Consumer<BlockTypeResTransformer<T>> extraModelTransform;
    protected final Predicate<T> condition;
    protected final boolean copyTint;

    protected AbstractSimpleEntrySet(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<ResourceKey<CreativeModeTab>> tab, TabAddMode tabMode, BiFunction<T, ResourceManager, Pair<List<Palette>, @Nullable McMetaFile>> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, boolean mergePalette, boolean copyTint, Predicate<T> condition) {
        this.typeName = (String)(prefix == null ? "" : prefix + (name.isEmpty() ? "" : "_")) + name;
        this.postfix = name;
        this.prefix = prefix;
        this.tab = tab;
        this.tabMode = tabMode;
        this.baseType = baseType;
        this.type = type;
        this.copyTint = copyTint;
        this.extraModelTransform = extraTransform;
        this.paletteSupplier = paletteSupplier;
        this.mergePalette = mergePalette;
        this.nameScheme = this.prefix != null ? (this.postfix.isEmpty() ? Pattern.compile("^" + prefix + "_(.+?)$") : Pattern.compile("^" + prefix + "_(.+?)_" + this.postfix + "$")) : Pattern.compile("^(.+?)_" + this.postfix + "$");
        this.condition = condition;
        if (tab == null && PlatHelper.isDev()) {
            throw new UnsupportedOperationException("Creative tab cant be null. Found null one for entry set " + this.getName());
        }
    }

    @Override
    public int getBlockCount() {
        return this.blocks.size();
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    @Override
    @Nullable
    public Item getItemOf(T type) {
        Item i = (Item)this.items.get(type);
        if (ModEntriesConfigs.isEntryEnabled(type, (Object)i)) {
            return i;
        }
        return null;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.type;
    }

    public T getBaseType() {
        return (T)((BlockType)this.baseType.get());
    }

    public String getEquivalentBlock(CompatModule module, String oldName, String woodFrom) {
        BlockType w;
        String wood = this.parseWoodType(oldName);
        if (wood != null && (w = BlockSetAPI.getBlockSet(this.getTypeClass()).get(new ResourceLocation(woodFrom, wood))) != null) {
            return module.shortenedId() + "/" + w.getNamespace() + "/" + oldName;
        }
        return null;
    }

    @Nullable
    public String parseWoodType(String oldName) {
        Matcher m = this.nameScheme.matcher(oldName);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    @Override
    public void registerBlockColors(ClientHelper.BlockColorEvent event) {
        if (this.copyTint) {
            ColoringUtils.copyBlockTint(event, this.blocks);
        }
    }

    @Override
    public void registerItemColors(ClientHelper.ItemColorEvent event) {
        if (this.copyTint) {
            ColoringUtils.copyBlockTint(event, this.blocks);
            ColoringUtils.copyItemTint(event, this.items);
        }
    }

    @Override
    public void registerItemsToExistingTabs(SimpleModule module, RegHelper.ItemToTabEvent event) {
        block7: {
            ResourceKey<CreativeModeTab> tab;
            block8: {
                block6: {
                    if (this.tab == null) {
                        if (PlatHelper.isDev()) {
                            throw new UnsupportedOperationException("Creative tab cant be null. Found null one for entry set " + this.getName());
                        }
                        return;
                    }
                    tab = this.tab.get();
                    if (tab.m_135782_().equals((Object)NO_TAB_MARKER)) {
                        return;
                    }
                    if (!BuiltInRegistries.f_279662_.m_142003_(tab)) {
                        throw new UnsupportedOperationException("Creative tab " + String.valueOf(tab) + " not registered found in the registries. This means that the target mod must have changed its name. You can either downgrade the mod" + tab.m_135782_().m_135827_() + " or wait for an Every Compat update");
                    }
                    if (this.tabMode != TabAddMode.AFTER_ALL) break block6;
                    event.add(tab, (ItemLike[])this.items.values().toArray(new Item[0]));
                    break block7;
                }
                if (this.tabMode != TabAddMode.AFTER_SAME_WOOD) break block8;
                BlockTypeRegistry reg = BlockSetAPI.getBlockSet(this.type);
                for (Map.Entry<T, I> e : this.items.entrySet()) {
                    Item item = (Item)e.getValue();
                    BlockType wood = (BlockType)e.getKey();
                    event.addAfter(tab, s -> reg.getBlockTypeOf((ItemLike)s.m_41720_()) == wood, new ItemLike[]{item});
                }
                break block7;
            }
            if (this.tabMode != TabAddMode.AFTER_SAME_TYPE) break block7;
            BlockTypeRegistry reg = BlockSetAPI.getBlockSet(this.type);
            String childKey = this.getChildKey(module);
            Class typeClass = this.getTypeClass();
            for (Map.Entry<T, I> e : this.items.entrySet()) {
                Item item = (Item)e.getValue();
                event.addAfter(tab, s -> {
                    BlockType type = reg.getBlockTypeOf((ItemLike)s.m_41720_());
                    if (type == null) {
                        return false;
                    }
                    return type.getClass() == typeClass && Objects.equals(type.getChildKey((Object)s.m_41720_()), childKey);
                }, new ItemLike[]{item});
            }
        }
    }

    @Override
    public void generateTags(SimpleModule module, DynamicDataPack pack, ResourceManager manager) {
        if (!this.tags.isEmpty()) {
            for (Map.Entry<ResourceLocation, Set<ResourceKey<?>>> tb : this.tags.entrySet()) {
                SimpleTagBuilder builder = SimpleTagBuilder.of((ResourceLocation)tb.getKey());
                for (Map.Entry<T, ?> entry : this.getDefaultEntries().entrySet()) {
                    if (!ModEntriesConfigs.isEntryEnabled((BlockType)entry.getKey(), entry.getValue())) continue;
                    builder.addEntry(entry.getValue());
                }
                for (ResourceKey resourceKey : tb.getValue()) {
                    pack.addTag(builder, resourceKey);
                }
            }
        }
    }

    public Map<T, ?> getDefaultEntries() {
        return this.blocks;
    }

    @Override
    public void generateRecipes(SimpleModule module, DynamicDataPack pack, ResourceManager manager) {
        int i = 0;
        for (Supplier<ResourceLocation> r : this.recipeLocations) {
            ResourceLocation res = r.get();
            try {
                ResourcesUtils.addBlocksRecipes(manager, pack, this.items, res, (BlockType)this.baseType.get(), i++);
            }
            catch (Exception e) {
                EveryCompat.LOGGER.error("Failed to generate recipes for template at location {} ", (Object)res, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateTextures(SimpleModule module, DynClientResourcesGenerator handler, ResourceManager manager) {
        if (this.textures.isEmpty()) {
            return;
        }
        ArrayList<TextureImage> images = new ArrayList<TextureImage>();
        try (TextureImage oakPlanksTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)((Block)this.getBaseType().mainChild())));){
            Palette oakPlanksPalette = Palette.fromImage((TextureImage)oakPlanksTexture);
            HashMap<ResourceLocation, Respriter> respriters = new HashMap<ResourceLocation, Respriter>();
            HashMap<ResourceLocation, TextureImage> partialRespriters = new HashMap<ResourceLocation, TextureImage>();
            Palette globalPalette = Palette.ofColors(new ArrayList());
            ArrayListMultimap infoPerTextures = ArrayListMultimap.create();
            for (TextureInfo textureInfo : this.textures) {
                ResourceLocation textureId = textureInfo.texture();
                try {
                    ResourceLocation maskId = textureInfo.mask();
                    TextureImage main = TextureImage.open((ResourceManager)manager, (ResourceLocation)textureId);
                    main.getMetadata();
                    infoPerTextures.put((Object)textureId, (Object)textureInfo);
                    if (textureInfo.copyTexture()) {
                        respriters.put(maskId, Respriter.ofPalette((TextureImage)main, List.of(Palette.ofColors(List.of(new RGBColor(1))))));
                        continue;
                    }
                    images.add(main);
                    if (maskId != null) {
                        if (textureInfo.autoMask()) {
                            if (this.mergePalette) {
                                globalPalette.addAll((Collection)oakPlanksPalette);
                                partialRespriters.put(textureId, main);
                                continue;
                            }
                            respriters.put(textureId, Respriter.ofPalette((TextureImage)main, (Palette)oakPlanksPalette));
                            continue;
                        }
                        TextureImage mask = TextureImage.open((ResourceManager)manager, (ResourceLocation)maskId);
                        if (this.mergePalette) {
                            globalPalette.addAll((Collection)Palette.fromImage((TextureImage)main, (TextureImage)mask, (float)0.0f));
                            partialRespriters.put(textureId, main);
                            continue;
                        }
                        respriters.put(textureId, Respriter.masked((TextureImage)main, (TextureImage)mask));
                        continue;
                    }
                    if (this.mergePalette) {
                        globalPalette.addAll((Collection)Palette.fromImage((TextureImage)main, null, (float)0.0f));
                        partialRespriters.put(textureId, main);
                        continue;
                    }
                    respriters.put(textureId, Respriter.of((TextureImage)main));
                }
                catch (UnsupportedOperationException e) {
                    EveryCompat.LOGGER.error("Could not generate textures for {}", (Object)textureInfo, (Object)e);
                }
                catch (Exception e) {
                    if (PlatHelper.isDev()) {
                        throw new RuntimeException(e);
                    }
                    EveryCompat.LOGGER.error("Failed to read block texture at {}", (Object)textureInfo, (Object)e);
                }
            }
            for (Map.Entry entry : partialRespriters.entrySet()) {
                respriters.put((ResourceLocation)entry.getKey(), Respriter.ofPalette((TextureImage)((TextureImage)entry.getValue()), (Palette)globalPalette));
            }
            for (Map.Entry entry : this.getDefaultEntries().entrySet()) {
                Object b = entry.getValue();
                BlockType w = (BlockType)entry.getKey();
                ResourceLocation blockId = Utils.getID(b);
                Pair<List<Palette>, McMetaFile> pal = this.paletteSupplier.apply(w, manager);
                McMetaFile targetAnimation = (McMetaFile)pal.getSecond();
                List targetPalette = (List)pal.getFirst();
                if (targetPalette == null) {
                    EveryCompat.LOGGER.error("Could not get texture palette for block {} : ", b);
                    continue;
                }
                int oldSize = ((Palette)targetPalette.get(0)).size();
                for (Map.Entry re : respriters.entrySet()) {
                    if (oldSize != ((Palette)targetPalette.get(0)).size()) {
                        throw new RuntimeException("This should not happen");
                    }
                    ResourceLocation oldTextureId = (ResourceLocation)re.getKey();
                    String oldPath = oldTextureId.m_135815_();
                    String newPath = oldPath.startsWith("entity/") && module.modId.equals("boatload") ? BlockTypeResTransformer.replaceFullGenericType((String)oldPath, (BlockType)w, (ResourceLocation)blockId, (String)((BlockType)this.baseType.get()).getTypeName(), null, (int)2) : BlockTypeResTransformer.replaceTypeNoNamespace((String)oldPath, (BlockType)w, (ResourceLocation)blockId, (String)((BlockType)this.baseType.get()).getTypeName());
                    String newId = "";
                    boolean isOnAtlas = true;
                    for (TextureInfo info : infoPerTextures.get((Object)oldTextureId)) {
                        if (info != null) {
                            newId = info.keepNamespace() ? oldTextureId.m_247449_(newPath).toString() : new ResourceLocation(blockId.m_135827_(), newPath).toString();
                            if (newId.isEmpty()) {
                                EveryCompat.LOGGER.error("The path of new texture is empty for: {}", (Object)info.texture());
                                continue;
                            }
                            isOnAtlas = info.onAtlas();
                            if (info.copyMCMETA()) {
                                ResourceLocation mcmetaLoc = ResType.MCMETA.getPath(oldTextureId);
                                Optional getMCMETA = manager.m_213713_(mcmetaLoc);
                                if (getMCMETA.isPresent()) {
                                    InputStream mcmetaStream = ((Resource)getMCMETA.get()).m_215507_();
                                    JsonObject mcmetaFile = RPUtils.deserializeJson((InputStream)mcmetaStream);
                                    ((DynamicTexturePack)handler.dynamicPack).addJson(ResourceLocation.m_135820_((String)newId), (JsonElement)mcmetaFile, ResType.MCMETA);
                                    mcmetaStream.close();
                                } else {
                                    handler.getLogger().error("The MCMETA file may no longer existing, check @ {}", (Object)mcmetaLoc);
                                }
                            }
                        }
                        Respriter respriter = (Respriter)re.getValue();
                        Supplier<TextureImage> textureSupplier = () -> respriter.recolorWithAnimation(targetPalette, targetAnimation);
                        textureSupplier = this.postProcessTexture(w, newId, manager, textureSupplier);
                        handler.addTextureIfNotPresent(manager, newId, textureSupplier, isOnAtlas);
                    }
                }
            }
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Could not generate any block texture for entry set {}: {}", (Object)(module == null ? "dummy" : module.modRes(this.getName())), (Object)e.getMessage());
        }
        finally {
            for (TextureImage t : images) {
                t.close();
            }
        }
    }

    public Supplier<TextureImage> postProcessTexture(T blockType, String newId, ResourceManager manager, Supplier<TextureImage> textureSupplier) {
        Supplier<TextureImage> changed;
        if (blockType.getClass() == WoodType.class && (changed = SpriteHelper.maybePostProcessWoodTexture((WoodType)blockType, newId, manager, textureSupplier)) != null) {
            return changed;
        }
        return textureSupplier;
    }

    private static Pair<List<Palette>, @Nullable McMetaFile> getPaletteFromMainChild(BlockType w, ResourceManager manager) {
        Pair pair;
        block12: {
            ItemLike mainChild = w.mainChild();
            Block mainWoodTypeBlock = null;
            if (mainChild instanceof Block) {
                Block bb;
                mainWoodTypeBlock = bb = (Block)mainChild;
            } else if (mainChild instanceof BlockItem) {
                BlockItem bii = (BlockItem)mainChild;
                mainWoodTypeBlock = bii.m_40614_();
            }
            if (mainWoodTypeBlock == null) {
                throw new UnsupportedOperationException("You need to provide a palette supplier for non block main child");
            }
            TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)mainWoodTypeBlock));
            try {
                List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                McMetaFile animation = plankTexture.getMcMeta();
                pair = Pair.of((Object)targetPalette, (Object)animation);
                if (plankTexture == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (plankTexture != null) {
                        try {
                            plankTexture.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return Pair.of(null, null);
                }
            }
            plankTexture.close();
        }
        return pair;
    }

    public static <T extends BlockType> @NotNull Pair<List<Palette>, @Nullable McMetaFile> makePaletteFromChild(Consumer<Palette> paletteTransform, String childKey, Predicate<String> whichSide, T blockType, ResourceManager m) {
        Object child = blockType.getChild(childKey);
        if (child instanceof Block) {
            Pair pair;
            block28: {
                Block b = (Block)child;
                if (whichSide != null) {
                    Pair pair2;
                    block27: {
                        TextureImage blockTexture = TextureImage.open((ResourceManager)m, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)m, (Block)b, whichSide));
                        try {
                            List targetPalette = Palette.fromAnimatedImage((TextureImage)blockTexture);
                            targetPalette.forEach(paletteTransform);
                            pair2 = Pair.of((Object)targetPalette, (Object)blockTexture.getMcMeta());
                            if (blockTexture == null) break block27;
                        }
                        catch (Throwable targetPalette) {
                            try {
                                if (blockTexture != null) {
                                    try {
                                        blockTexture.close();
                                    }
                                    catch (Throwable throwable) {
                                        targetPalette.addSuppressed(throwable);
                                    }
                                }
                                throw targetPalette;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(String.format("Failed to generate palette for %s : %s", blockType, e));
                            }
                        }
                        blockTexture.close();
                    }
                    return pair2;
                }
                TextureImage plankTexture = TextureImage.open((ResourceManager)m, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)m, (Block)b));
                try {
                    List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                    targetPalette.forEach(paletteTransform);
                    pair = Pair.of((Object)targetPalette, (Object)plankTexture.getMcMeta());
                    if (plankTexture == null) break block28;
                }
                catch (Throwable targetPalette) {
                    try {
                        if (plankTexture != null) {
                            try {
                                plankTexture.close();
                            }
                            catch (Throwable throwable) {
                                targetPalette.addSuppressed(throwable);
                            }
                        }
                        throw targetPalette;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(String.format("Failed to generate palette for %s : %s", blockType, e));
                    }
                }
                plankTexture.close();
            }
            return pair;
        }
        if (child instanceof Item) {
            Pair pair;
            block29: {
                Item i = (Item)child;
                TextureImage plankTexture = TextureImage.open((ResourceManager)m, (ResourceLocation)RPUtils.findFirstItemTextureLocation((ResourceManager)m, (Item)i));
                try {
                    List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                    targetPalette.forEach(paletteTransform);
                    pair = Pair.of((Object)targetPalette, (Object)plankTexture.getMcMeta());
                    if (plankTexture == null) break block29;
                }
                catch (Throwable throwable) {
                    try {
                        if (plankTexture != null) {
                            try {
                                plankTexture.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(String.format("Failed to generate palette for %s : %s", blockType, e));
                    }
                }
                plankTexture.close();
            }
            return pair;
        }
        throw new RuntimeException("No child with key " + childKey + " found");
    }

    @Override
    @Nullable
    public Item getItemForECTab(T type) {
        if (this.tab == null) {
            if (PlatHelper.isDev()) {
                throw new UnsupportedOperationException("Creative tab cant be null. Found null one for entry set " + this.getName());
            }
            EveryCompat.LOGGER.error("Creative tab cant be null. Found null one for entry set {}", (Object)this.getName());
            return null;
        }
        try {
            ResourceKey<CreativeModeTab> tagKey = this.tab.get();
            if (tagKey.m_135782_().equals((Object)NO_TAB_MARKER)) {
                return null;
            }
        }
        catch (Exception e) {
            if (PlatHelper.isDev()) {
                throw e;
            }
            EveryCompat.LOGGER.error("Failed to get creative tab for entry set {}", (Object)this.getName(), (Object)e);
            return null;
        }
        return EntrySet.super.getItemForECTab(type);
    }

    protected static class Builder<BL extends Builder<BL, T, B, I>, T extends BlockType, B extends Block, I extends Item> {
        protected final Class<T> type;
        protected final Supplier<T> baseType;
        protected final String name;
        @Nullable
        protected final String prefix;
        protected Supplier<ResourceKey<CreativeModeTab>> tab = null;
        protected TabAddMode tabMode = TabAddMode.AFTER_SAME_TYPE;
        protected BiFunction<T, ResourceManager, Pair<List<Palette>, @Nullable McMetaFile>> palette = AbstractSimpleEntrySet::getPaletteFromMainChild;
        protected final Map<ResourceLocation, Set<ResourceKey<?>>> tags = new HashMap();
        protected final Set<Supplier<ResourceLocation>> recipes = new HashSet<Supplier<ResourceLocation>>();
        protected final Set<TextureInfo> textures = new HashSet<TextureInfo>();
        protected boolean useMergedPalette;
        @Nullable
        protected Consumer<BlockTypeResTransformer<T>> extraModelTransform = null;
        protected Predicate<T> condition = w -> true;
        protected boolean copyTint = false;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType) {
            this.baseType = baseType;
            this.name = name;
            this.prefix = prefix;
            this.type = type;
        }

        public BL addModelTransform(Consumer<BlockTypeResTransformer<T>> transform) {
            this.extraModelTransform = transform;
            return (BL)this;
        }

        public BL requiresChildren(String ... childKeys) {
            this.addCondition(w -> {
                for (String c : childKeys) {
                    if (w.getChild(c) != null) continue;
                    return false;
                }
                return true;
            });
            return (BL)this;
        }

        public BL requiresFromMap(Map<T, ?> entrySet) {
            this.addCondition(blockType -> !Objects.isNull(entrySet.get(blockType)));
            return (BL)this;
        }

        public BL excludeBlockTypes(String regEx) {
            this.addCondition(blockType -> !blockType.getId().toString().matches(regEx));
            return (BL)this;
        }

        public BL excludeBlockTypes(String modId, String ... typeIds) {
            StringBuilder regexBuilder = new StringBuilder();
            regexBuilder.append(modId).append(":(");
            for (int i = 0; i < typeIds.length; ++i) {
                regexBuilder.append(typeIds[i]);
                if (i == typeIds.length - 1) continue;
                regexBuilder.append("|");
            }
            regexBuilder.append(")");
            this.addCondition(blockType -> !blockType.getId().toString().matches(regexBuilder.toString()));
            return (BL)this;
        }

        public BL addCondition(Predicate<T> newCondition) {
            this.condition = this.condition == null ? newCondition : this.condition.and(newCondition);
            return (BL)this;
        }

        public BL copyParentTint() {
            this.copyTint = true;
            return (BL)this;
        }

        public BL setTabMode(TabAddMode mode) {
            this.tabMode = mode;
            return (BL)this;
        }

        public BL noTab() {
            return this.setTabKey(NO_TAB_MARKER);
        }

        public BL setTabKey(ResourceLocation res) {
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)res);
            this.tab = () -> key;
            return (BL)this;
        }

        @Deprecated(forRemoval=true)
        public BL setTabKey(Supplier<ResourceKey<CreativeModeTab>> tab) {
            this.tab = tab;
            return (BL)this;
        }

        public BL setTabKey(ResourceKey<CreativeModeTab> key) {
            this.tab = () -> key;
            return (BL)this;
        }

        @Deprecated(forRemoval=true)
        public BL setTab(Supplier<CreativeModeTab> tab) {
            this.tab = Suppliers.memoize(() -> (ResourceKey)BuiltInRegistries.f_279662_.m_7854_((Object)((CreativeModeTab)tab.get())).get());
            return (BL)this;
        }

        public BL addTag(ResourceLocation location, ResourceKey<?> registry) {
            Set s = this.tags.computeIfAbsent(location, b -> new HashSet());
            s.add(registry);
            return (BL)this;
        }

        public BL addTag(TagKey<?> tag, ResourceKey<?> registry) {
            this.addTag(tag.f_203868_(), registry);
            return (BL)this;
        }

        public BL addRecipe(ResourceLocation resourceLocation) {
            this.recipes.add(() -> resourceLocation);
            return (BL)this;
        }

        public BL addTexture(TextureInfo.Builder textureLoc) {
            if (PlatHelper.getPhysicalSide().isClient()) {
                TextureInfo info = textureLoc.build();
                this.textures.add(info);
                if (info.keepNamespace()) {
                    ((DynamicTexturePack)ClientDynamicResourcesHandler.getInstance().dynamicPack).addNamespaces(new String[]{info.texture().m_135827_()});
                }
            }
            return (BL)this;
        }

        public BL addTexture(ResourceLocation resourceLocation) {
            return this.addTexture(TextureInfo.of(resourceLocation));
        }

        public BL addTextureM(ResourceLocation textureLocation, ResourceLocation maskLocation) {
            return this.addTexture(TextureInfo.of(textureLocation).mask(maskLocation));
        }

        public BL addTextureAutoM(ResourceLocation textureLocation) {
            return this.addTexture(TextureInfo.of(textureLocation).autoMask());
        }

        public BL useMergedPalette() {
            this.useMergedPalette = true;
            return (BL)this;
        }

        public BL setPalette(BiFunction<T, ResourceManager, Pair<List<Palette>, @Nullable McMetaFile>> paletteProvider) {
            this.palette = paletteProvider;
            return (BL)this;
        }

        public BL createPaletteFromPlanks(Consumer<Palette> paletteTransform) {
            return this.createPaletteFromChild(paletteTransform, "planks");
        }

        public BL createPaletteFromPlanks() {
            return this.createPaletteFromPlanks(p -> {});
        }

        public BL createPaletteFromChild(Consumer<Palette> paletteTransform, String childKey) {
            return this.createPaletteFromChild(paletteTransform, childKey, null);
        }

        public BL createPaletteFromChild(String childKey, Predicate<String> whichSide) {
            return this.createPaletteFromChild(p -> {}, childKey, whichSide);
        }

        public BL createPaletteFromChild(String childKey) {
            return this.createPaletteFromChild(p -> {}, childKey, null);
        }

        public BL createPaletteFromChild(Consumer<Palette> paletteTransform, String childKey, Predicate<String> whichSide) {
            return this.setPalette((blockType, m) -> AbstractSimpleEntrySet.makePaletteFromChild(paletteTransform, childKey, whichSide, blockType, m));
        }
    }
}

