/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.panoramica;

import de.keksuccino.panoramica.Keybinds;
import de.keksuccino.panoramica.Panoramica;
import java.io.File;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PanoramicaHandler {
    private boolean active = false;
    private Minecraft mc = Minecraft.m_91087_();

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new PanoramicaHandler());
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            try {
                if (Keybinds.keybindCreatePano.m_90857_() && !this.active) {
                    this.createPanorama();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void createPanorama() {
        this.active = true;
        File savePath = PanoramicaHandler.getUnusedPanoramaFolderName();
        if (!savePath.exists()) {
            savePath.mkdirs();
        }
        int res = (Integer)Panoramica.config.getOrDefault("panoramaresolution", (Object)512);
        this.mc.f_91074_.m_213846_(Minecraft.m_91087_().m_167899_(savePath, res, res));
        this.active = false;
    }

    private static File getUnusedPanoramaFolderName() {
        File saveTo = new File(Minecraft.m_91087_().f_91069_.getPath() + "/screenshots");
        try {
            return PanoramicaHandler.getFolder(saveTo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new File(saveTo.getPath() + "/panorama_" + System.currentTimeMillis());
        }
    }

    private static File getFolder(File file) {
        File file2;
        String string = Util.m_241986_();
        int i = 1;
        while ((file2 = new File(file, "panorama_" + string + (String)(i == 1 ? "" : "_" + i))).exists()) {
            ++i;
        }
        return file2;
    }
}

