/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.qio;

import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.storage.MEStorage;
import me.ramidzkh.mekae2.AppliedMekanistics;
import me.ramidzkh.mekae2.qio.QioStorageAdapter;
import mekanism.api.inventory.qio.IQIOComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QioSupport {
    public static final Capability<MEStorage> STORAGE = CapabilityManager.get((CapabilityToken)new CapabilityToken<MEStorage>(){});
    private static final ResourceLocation DASHBOARD = new ResourceLocation("mekanism", "qio_dashboard");

    public static void initialize() {
        MinecraftForge.EVENT_BUS.addGenericListener(BlockEntity.class, QioSupport::onBlockEntityCapability);
    }

    public static void onBlockEntityCapability(AttachCapabilitiesEvent<BlockEntity> event) {
        final BlockEntity object = (BlockEntity)event.getObject();
        if (object instanceof IQIOComponent && DASHBOARD.equals((Object)ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)object.m_58903_()))) {
            event.addCapability(AppliedMekanistics.id("qio_storage_monitorable"), new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
                    IInWorldGridNodeHost host;
                    if (capability == STORAGE && arg != null && (host = GridHelper.getNodeHost((Level)object.m_58904_(), (BlockPos)object.m_58899_().m_121945_(arg))) != null) {
                        QioStorageAdapter<BlockEntity> adapter;
                        IGridNode source = host.getGridNode(arg.m_122424_());
                        if (source == null) {
                            source = host.getGridNode(null);
                        }
                        if (source != null && (adapter = new QioStorageAdapter<BlockEntity>((BlockEntity)((IQIOComponent)object), arg, source.getOwningPlayerProfileId())).getFrequency() != null) {
                            return LazyOptional.of(() -> adapter).cast();
                        }
                    }
                    return LazyOptional.empty();
                }
            });
        }
    }
}

