/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.forge.common.wrapper;

import fr.rakambda.fallingtree.common.wrapper.IBlockEntity;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.IChunk;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IRandomSource;
import fr.rakambda.fallingtree.forge.common.wrapper.BlockEntityWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.BlockStateWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.ChunkAccessWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.RandomSourceWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LevelWrapper
implements ILevel {
    private static final Logger log = LogManager.getLogger(LevelWrapper.class);
    @NotNull
    private final LevelAccessor raw;

    @Override
    public boolean isServer() {
        return !this.raw.m_5776_();
    }

    @Override
    @NotNull
    public IChunk getChunk(@NotNull IBlockPos blockPos) {
        BlockPos pos = (BlockPos)blockPos.getRaw();
        return new ChunkAccessWrapper(this.raw.m_46865_(pos));
    }

    @Override
    public boolean hasChunk(int x, int z) {
        return this.raw.m_7232_(x, z);
    }

    @Override
    @NotNull
    public IBlockState getBlockState(@NotNull IBlockPos blockPos) {
        BlockPos pos = (BlockPos)blockPos.getRaw();
        return new BlockStateWrapper(this.raw.m_8055_(pos));
    }

    @Override
    @Nullable
    public IBlockEntity getBlockEntity(@NotNull IBlockPos blockPos) {
        BlockEntity entity = this.raw.m_7702_((BlockPos)blockPos.getRaw());
        return entity == null ? null : new BlockEntityWrapper(entity);
    }

    @Override
    @NotNull
    public IRandomSource getRandom() {
        return new RandomSourceWrapper(this.raw.m_213780_());
    }

    @Override
    public boolean removeBlock(@NotNull IBlockPos blockPos, boolean b) {
        return this.raw.m_7471_((BlockPos)blockPos.getRaw(), b);
    }

    @Override
    public void fallBlock(@NotNull IBlockPos logBlockPos, boolean drop, double dx, double dy, double dz, double vx, double vy, double vz) {
        FallingBlockEntity entity = this.createFallingEntity(logBlockPos, dx, dy, dz);
        if (!drop) {
            entity.m_272001_();
        }
        entity.m_20334_(vx, vy, vz);
        this.raw.m_7967_((Entity)entity);
    }

    @NotNull
    private FallingBlockEntity createFallingEntity(@NotNull IBlockPos logBlockPos, double dx, double dy, double dz) {
        double x = (double)logBlockPos.getX() + dx;
        double y = (double)logBlockPos.getY() + dy;
        double z = (double)logBlockPos.getZ() + dz;
        BlockState blockState = (BlockState)this.getBlockState(logBlockPos).getRaw();
        BlockState newBlockState = blockState.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)) : blockState;
        FallingBlockEntity entity = new FallingBlockEntity(EntityType.f_20450_, (Level)this.raw);
        entity.f_19850_ = true;
        entity.m_6034_(x, y, z);
        entity.f_19854_ = x;
        entity.f_19855_ = y;
        entity.f_19856_ = z;
        entity.f_31946_ = newBlockState;
        return entity;
    }

    public LevelWrapper(@NotNull LevelAccessor raw) {
        if (raw == null) {
            throw new NullPointerException("raw is marked non-null but is null");
        }
        this.raw = raw;
    }

    public String toString() {
        return "LevelWrapper(raw=" + this.getRaw() + ")";
    }

    @NotNull
    public LevelAccessor getRaw() {
        return this.raw;
    }
}

