/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.integration.rei.categories.item;

import com.aetherteam.aether.recipe.recipes.item.AbstractAetherCookingRecipe;
import com.aetherteam.aether.recipe.recipes.item.AltarRepairRecipe;
import com.aetherteam.aether.recipe.recipes.item.IncubationRecipe;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public class AetherCookingRecipeDisplay<T extends Recipe<?>>
extends BasicDisplay {
    private final CategoryIdentifier<?> identifier;
    private final float experience;
    private final int cookingTime;
    private final boolean isIncubation;

    public AetherCookingRecipeDisplay(CategoryIdentifier<AetherCookingRecipeDisplay<T>> identifier, List<EntryIngredient> inputs, List<EntryIngredient> outputs, float experience, int cookingTime, boolean isIncubation, Optional<ResourceLocation> location) {
        super(inputs, outputs, location);
        this.identifier = identifier;
        this.experience = experience;
        this.cookingTime = cookingTime;
        this.isIncubation = isIncubation;
    }

    public static <T extends Recipe<?>> AetherCookingRecipeDisplay<T> of(CategoryIdentifier<AetherCookingRecipeDisplay<T>> categoryIdentifier, T recipe) {
        int cookingTime = 0;
        float experience = 0.0f;
        if (recipe instanceof AbstractCookingRecipe) {
            AbstractCookingRecipe cookingRecipe = (AbstractCookingRecipe)recipe;
            cookingTime = cookingRecipe.m_43753_();
            experience = cookingRecipe.m_43750_();
        } else if (recipe instanceof IncubationRecipe) {
            IncubationRecipe incubationRecipe = (IncubationRecipe)recipe;
            cookingTime = incubationRecipe.getIncubationTime();
        }
        return new AetherCookingRecipeDisplay<T>(categoryIdentifier, AetherCookingRecipeDisplay.getInput(recipe), AetherCookingRecipeDisplay.getOutput(recipe), experience, cookingTime, recipe instanceof IncubationRecipe, Optional.of(recipe.m_6423_()));
    }

    private static List<EntryIngredient> getInput(Recipe<?> recipe) {
        if (recipe instanceof AltarRepairRecipe) {
            ItemStack damagedItem = ((Ingredient)recipe.m_7527_().get(0)).m_43908_()[0].m_41777_();
            damagedItem.m_41721_(damagedItem.m_41776_() * 3 / 4);
            return List.of(EntryIngredients.of((ItemStack)damagedItem));
        }
        return List.of(EntryIngredients.ofIngredient((Ingredient)((Ingredient)recipe.m_7527_().get(0))));
    }

    private static List<EntryIngredient> getOutput(Recipe<?> recipe) {
        List<EntryIngredient> list;
        if (recipe instanceof AbstractAetherCookingRecipe) {
            AbstractAetherCookingRecipe cookingRecipe = (AbstractAetherCookingRecipe)recipe;
            list = List.of(EntryIngredients.of((ItemStack)cookingRecipe.getResult()));
        } else {
            list = List.of();
        }
        return list;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public boolean isIncubation() {
        return this.isIncubation;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return this.identifier;
    }

    public static <T extends Recipe<?>> DisplaySerializer<AetherCookingRecipeDisplay<T>> serializer(CategoryIdentifier<AetherCookingRecipeDisplay<T>> identifier) {
        return BasicDisplay.Serializer.of((input, output, location1, tag) -> {
            float experience = tag.m_128457_("experience");
            int cookingTime = tag.m_128451_("cookingTime");
            boolean isIncubation = tag.m_128471_("isIncubation");
            return new AetherCookingRecipeDisplay(identifier, input, output, experience, cookingTime, isIncubation, location1);
        }, (display, tag) -> {
            tag.m_128350_("experience", display.experience);
            tag.m_128405_("cookingTime", display.cookingTime);
            tag.m_128379_("isIncubation", display.isIncubation);
        });
    }
}

