/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon.boss;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.capability.AetherCapabilities;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.data.resources.registries.AetherDamageTypes;
import com.aetherteam.aether.entity.AetherBossMob;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.ai.controller.BlankMoveControl;
import com.aetherteam.aether.entity.monster.dungeon.FireMinion;
import com.aetherteam.aether.entity.monster.dungeon.boss.BossNameGenerator;
import com.aetherteam.aether.entity.projectile.crystal.AbstractCrystal;
import com.aetherteam.aether.entity.projectile.crystal.FireCrystal;
import com.aetherteam.aether.entity.projectile.crystal.IceCrystal;
import com.aetherteam.aether.event.AetherEventDispatch;
import com.aetherteam.aether.mixin.mixins.common.accessor.LookAtPlayerGoalAccessor;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.serverbound.BossInfoPacket;
import com.aetherteam.nitrogen.entity.BossRoomTracker;
import com.aetherteam.nitrogen.network.PacketRelay;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.simple.SimpleChannel;

public class SunSpirit
extends PathfinderMob
implements AetherBossMob<SunSpirit>,
Enemy,
IEntityAdditionalSpawnData {
    private static final double DEFAULT_SPEED_MODIFIER = 1.0;
    private static final double FROZEN_SPEED_MODIFIER = 0.3;
    private static final float INCINERATION_DAMAGE = 10.0f;
    private static final int INCINERATION_FIRE_DURATION = 8;
    private static final int SUN_SPIRIT_FROZEN_DURATION = 175;
    private static final int ICE_CRYSTAL_SHOOT_COUNT_INTERVAL = 5;
    private static final int SHOOT_CRYSTAL_INTERVAL = 50;
    private static final int SPAWN_FIRE_INTERVAL = 35;
    private static final EntityDataAccessor<Boolean> DATA_IS_FROZEN = SynchedEntityData.m_135353_(SunSpirit.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_FROZEN_DURATION = SynchedEntityData.m_135353_(SunSpirit.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Component> DATA_BOSS_NAME = SynchedEntityData.m_135353_(SunSpirit.class, (EntityDataSerializer)EntityDataSerializers.f_135031_);
    private static final Music SUN_SPIRIT_MUSIC = new Music((Holder)AetherSoundEvents.MUSIC_BOSS_SUN_SPIRIT.getHolder().orElseThrow(), 0, 0, true);
    public static final Map<Block, Function<BlockState, BlockState>> DUNGEON_BLOCK_CONVERSIONS = new HashMap<Block, Function<BlockState, BlockState>>(Map.ofEntries(Map.entry((Block)AetherBlocks.LOCKED_HELLFIRE_STONE.get(), blockState -> ((Block)AetherBlocks.HELLFIRE_STONE.get()).m_49966_()), Map.entry((Block)AetherBlocks.LOCKED_LIGHT_HELLFIRE_STONE.get(), blockState -> ((Block)AetherBlocks.LIGHT_HELLFIRE_STONE.get()).m_49966_()), Map.entry((Block)AetherBlocks.BOSS_DOORWAY_HELLFIRE_STONE.get(), blockState -> Blocks.f_50016_.m_49966_()), Map.entry((Block)AetherBlocks.TREASURE_DOORWAY_HELLFIRE_STONE.get(), blockState -> Blocks.f_50016_.m_49966_())));
    private final ServerBossEvent bossFight;
    @Nullable
    private BossRoomTracker<SunSpirit> dungeon;
    private Vec3 origin;
    private int xMax = 9;
    private int zMax = 9;
    private int chatLine;
    private int chatCooldown;
    protected double speedModifier;

    public SunSpirit(EntityType<? extends SunSpirit> type, Level level) {
        super(type, level);
        this.f_21342_ = new BlankMoveControl((Mob)this);
        this.bossFight = (ServerBossEvent)new ServerBossEvent(this.getBossName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).m_7005_(true);
        this.setBossFight(false);
        this.origin = this.m_20182_();
        this.f_21364_ = 50;
        this.f_19794_ = true;
        this.speedModifier = 1.0;
        this.m_21530_();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        this.setBossName((Component)BossNameGenerator.generateSunSpiritName(this.m_217043_()));
        this.origin = this.m_20182_();
        return spawnData;
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new DoNothingGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new SunSpiritLookGoal((Mob)this, Player.class, 40.0f, 1.0f));
        this.f_21345_.m_25352_(2, (Goal)new ShootFireballGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SummonFireGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new FlyAroundGoal(this));
    }

    public static AttributeSupplier.Builder m_21552_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22279_, 0.35);
    }

    public void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_IS_FROZEN, (Object)false);
        this.m_20088_().m_135372_(DATA_FROZEN_DURATION, (Object)0);
        this.m_20088_().m_135372_(DATA_BOSS_NAME, (Object)Component.m_237113_((String)"Sun Spirit"));
    }

    public void m_8119_() {
        super.m_8119_();
        this.evaporate();
        if (this.getChatCooldown() > 0) {
            --this.chatCooldown;
        }
        if (this.m_21223_() > 0.0f && !this.isFrozen()) {
            double x = this.m_20185_() + (double)((this.m_217043_().m_188501_() - 0.5f) * this.m_217043_().m_188501_());
            double y = this.m_20191_().f_82289_ + (double)this.m_217043_().m_188501_() - 0.5;
            double z = this.m_20189_() + (double)((this.m_217043_().m_188501_() - 0.5f) * this.m_217043_().m_188501_());
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, -0.075, 0.0);
            this.burnEntities();
        }
        this.m_146922_(Mth.m_14094_((float)this.m_146908_(), (float)this.m_6080_(), (float)20.0f));
        this.speedModifier = this.isFrozen() ? 0.3 : 1.0;
    }

    private void evaporate() {
        AABB boundingBox = this.m_20191_();
        BlockPos min = BlockPos.m_274561_((double)(boundingBox.f_82288_ - (double)this.xMax), (double)(boundingBox.f_82289_ - 3.0), (double)(boundingBox.f_82290_ - (double)this.zMax));
        BlockPos max = BlockPos.m_274561_((double)(Math.ceil(boundingBox.f_82291_ - 1.0) + (double)this.xMax), (double)(Math.ceil(boundingBox.f_82292_ - 1.0) + 4.0), (double)(Math.ceil(boundingBox.f_82293_ - 1.0) + (double)this.zMax));
        AetherBossMob.super.evaporate(this, min, max, blockState -> true);
    }

    public void burnEntities() {
        List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82363_(0.0, -2.0, 0.0).m_82310_(-0.75, 0.0, -0.75).m_82310_(0.75, 0.0, 0.75));
        for (Entity target : entities) {
            if (!(target instanceof LivingEntity)) continue;
            target.m_6469_(AetherDamageTypes.entityDamageSource(this.m_9236_(), AetherDamageTypes.INCINERATION, (Entity)this), 10.0f);
            target.m_20254_(8);
        }
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossFight.m_142711_(this.m_21223_() / this.m_21233_());
        this.trackDungeon();
        this.checkIceCrystals();
        if (this.getFrozenDuration() > 0) {
            this.setFrozenDuration(this.getFrozenDuration() - 1);
        } else {
            this.setFrozen(false);
        }
    }

    private void checkIceCrystals() {
        for (IceCrystal iceCrystal : this.m_9236_().m_45976_(IceCrystal.class, this.m_20191_().m_82400_(0.1))) {
            iceCrystal.doDamage((Entity)this);
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_9236_().m_5776_() && !this.isBossFight() && this.getChatCooldown() <= 0) {
            this.setChatCooldown(14);
            if (this.getDungeon() == null || this.getDungeon().isPlayerWithinRoomInterior((Entity)player)) {
                LazyOptional aetherPlayer = player.getCapability(AetherCapabilities.AETHER_PLAYER_CAPABILITY);
                if (this.m_9236_().m_46791_() != Difficulty.PEACEFUL) {
                    if (!((Boolean)AetherConfig.COMMON.repeat_sun_spirit_dialogue.get()).booleanValue()) {
                        aetherPlayer.ifPresent(cap -> {
                            if (cap.hasSeenSunSpiritDialogue() && this.chatLine == 0) {
                                this.chatLine = 10;
                            }
                        });
                    }
                    if (this.chatLine < 9) {
                        this.m_5496_(this.getInteractSound(), 1.0f, this.m_6100_());
                    }
                    switch (this.chatLine++) {
                        case 0: {
                            this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.sun_spirit.line0").m_130940_(ChatFormatting.RED));
                            break;
                        }
                        case 1: {
                            this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.sun_spirit.line1").m_130940_(ChatFormatting.RED));
                            break;
                        }
                        case 2: {
                            this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.sun_spirit.line2").m_130940_(ChatFormatting.RED));
                            break;
                        }
                        case 3: {
                            this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.sun_spirit.line3").m_130940_(ChatFormatting.RED));
                            break;
                        }
                        case 4: {
                            this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.sun_spirit.line4").m_130940_(ChatFormatting.RED));
                            break;
                        }
                        case 5: {
                            this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.sun_spirit.line5.1").m_130940_(ChatFormatting.RED));
                            this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.sun_spirit.line5.2").m_130940_(ChatFormatting.RED));
                            break;
                        }
                        case 6: {
                            this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.sun_spirit.line6.1").m_130940_(ChatFormatting.RED));
                            this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.sun_spirit.line6.2").m_130940_(ChatFormatting.RED));
                            break;
                        }
                        case 7: {
                            this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.sun_spirit.line7.1").m_130940_(ChatFormatting.RED));
                            this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.sun_spirit.line7.2").m_130940_(ChatFormatting.RED));
                            break;
                        }
                        case 8: {
                            this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.sun_spirit.line8").m_130940_(ChatFormatting.RED));
                            break;
                        }
                        case 9: {
                            this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.sun_spirit.line9").m_130940_(ChatFormatting.GOLD));
                            this.m_21153_(this.m_21233_());
                            this.setBossFight(true);
                            if (this.getDungeon() != null) {
                                this.closeRoom();
                            }
                            this.m_5496_(this.getActivateSound(), 1.0f, this.m_6100_());
                            AetherEventDispatch.onBossFightStart((Entity)this, this.getDungeon());
                            aetherPlayer.ifPresent(cap -> cap.setSeenSunSpiritDialogue(true));
                            break;
                        }
                        default: {
                            this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.sun_spirit.line10").m_130940_(ChatFormatting.RED));
                            this.chatLine = 9;
                            break;
                        }
                    }
                } else {
                    this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.sun_spirit.line1").m_130940_(ChatFormatting.RED));
                }
            } else {
                this.displayTooFarMessage(player);
            }
        }
        return super.m_6071_(player, hand);
    }

    protected void chatWithNearby(Component message) {
        AABB room = this.getDungeon() == null ? this.m_20191_().m_82400_(16.0) : this.getDungeon().roomBounds();
        this.m_9236_().m_45955_(NON_COMBAT, (LivingEntity)this, room).forEach(player -> player.m_213846_(message));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity;
        boolean flag = super.m_6469_(source, amount);
        if (!this.m_9236_().m_5776_() && flag && this.m_21223_() > 0.0f && (entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (source.m_7640_() instanceof IceCrystal) {
                this.setFrozen(true);
                this.setFrozenDuration(175);
                FireMinion minion = new FireMinion((EntityType<? extends FireMinion>)((EntityType)AetherEntityTypes.FIRE_MINION.get()), this.m_9236_());
                minion.m_146884_(this.m_20182_());
                minion.m_6710_(entity2);
                this.m_9236_().m_7967_((Entity)minion);
            }
        }
        return flag;
    }

    public void reset() {
        this.setBossFight(false);
        this.m_6710_(null);
        if (this.dungeon != null) {
            this.openRoom();
        }
        AetherEventDispatch.onBossFightStop((Entity)this, this.getDungeon());
    }

    public void m_6667_(DamageSource source) {
        if (!this.m_9236_().m_5776_()) {
            this.setFrozen(true);
            this.bossFight.m_142711_(this.m_21223_() / this.m_21233_());
            this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.sun_spirit.dead").m_130940_(ChatFormatting.AQUA));
            if (this.getDungeon() != null) {
                this.getDungeon().grantAdvancements(source);
                this.tearDownRoom();
            }
            this.m_9236_().getCapability(AetherCapabilities.AETHER_TIME_CAPABILITY).ifPresent(aetherTime -> {
                aetherTime.setEternalDay(false);
                aetherTime.updateEternalDay();
            });
        }
        super.m_6667_(source);
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public void m_5997_(double x, double y, double z) {
    }

    public boolean m_7301_(MobEffectInstance pEffectInstance) {
        MobEffectEvent.Applicable event = new MobEffectEvent.Applicable((LivingEntity)this, pEffectInstance);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() != Event.Result.DEFAULT) {
            return event.getResult() == Event.Result.ALLOW;
        }
        return false;
    }

    public void m_6043_() {
    }

    @Nullable
    public BlockState convertBlock(BlockState state) {
        return DUNGEON_BLOCK_CONVERSIONS.getOrDefault(state.m_60734_(), blockState -> null).apply(state);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new BossInfoPacket.Display(this.bossFight.m_18860_(), this.m_19879_()), (ServerPlayer)player);
        if (this.getDungeon() == null || this.getDungeon().isPlayerTracked((Player)player)) {
            this.bossFight.m_6543_(player);
            AetherEventDispatch.onBossFightPlayerAdd((Entity)this, this.getDungeon(), player);
        }
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new BossInfoPacket.Remove(this.bossFight.m_18860_(), this.m_19879_()), (ServerPlayer)player);
        this.bossFight.m_6539_(player);
        AetherEventDispatch.onBossFightPlayerRemove((Entity)this, this.getDungeon(), player);
    }

    public void onDungeonPlayerAdded(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.bossFight.m_6543_(serverPlayer);
            AetherEventDispatch.onBossFightPlayerAdd((Entity)this, this.getDungeon(), serverPlayer);
        }
    }

    public void onDungeonPlayerRemoved(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.bossFight.m_6539_(serverPlayer);
            if (!serverPlayer.m_6084_()) {
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"gui.aether.sun_spirit.playerdeath").m_130940_(ChatFormatting.RED));
            }
            AetherEventDispatch.onBossFightPlayerRemove((Entity)this, this.getDungeon(), serverPlayer);
        }
    }

    public boolean isFrozen() {
        return (Boolean)this.m_20088_().m_135370_(DATA_IS_FROZEN);
    }

    public void setFrozen(boolean frozen) {
        this.m_20088_().m_135381_(DATA_IS_FROZEN, (Object)frozen);
    }

    public int getFrozenDuration() {
        return (Integer)this.m_20088_().m_135370_(DATA_FROZEN_DURATION);
    }

    public void setFrozenDuration(int duration) {
        this.m_20088_().m_135381_(DATA_FROZEN_DURATION, (Object)duration);
    }

    public Component getBossName() {
        if (this.m_8077_()) {
            return this.m_7770_();
        }
        if (!((Boolean)AetherConfig.COMMON.randomize_boss_names.get()).booleanValue()) {
            return Component.m_237115_((String)"entity.aether.sun_spirit");
        }
        return (Component)this.m_20088_().m_135370_(DATA_BOSS_NAME);
    }

    public void setBossName(Component component) {
        this.m_20088_().m_135381_(DATA_BOSS_NAME, (Object)component);
        this.bossFight.m_6456_(component);
    }

    @Nullable
    public BossRoomTracker<SunSpirit> getDungeon() {
        return this.dungeon;
    }

    public void setDungeon(@Nullable BossRoomTracker<SunSpirit> dungeon) {
        this.dungeon = dungeon;
        if (dungeon != null) {
            this.origin = dungeon.originCoordinates();
            this.xMax = this.zMax = Mth.m_14107_((double)(dungeon.roomBounds().m_82362_() / 2.0 - 5.0));
        } else {
            this.origin = this.m_20182_();
            this.xMax = 9;
            this.zMax = 9;
        }
    }

    public boolean isBossFight() {
        return this.bossFight.m_8323_();
    }

    public void setBossFight(boolean isFighting) {
        this.bossFight.m_8321_(isFighting);
    }

    @Override
    @Nullable
    public ResourceLocation getBossBarTexture() {
        return new ResourceLocation("aether", "textures/gui/boss_bar_sun_spirit.png");
    }

    @Override
    @Nullable
    public Music getBossMusic() {
        return SUN_SPIRIT_MUSIC;
    }

    public int getChatCooldown() {
        return this.chatCooldown;
    }

    public void setChatCooldown(int cooldown) {
        this.chatCooldown = cooldown;
    }

    public int getDeathScore() {
        return this.f_20897_;
    }

    public boolean m_6673_(DamageSource source) {
        if (this.m_213877_()) {
            return true;
        }
        if (this.isFrozen()) {
            return !(source.m_7639_() instanceof LivingEntity) || source.m_7639_() instanceof SunSpirit;
        }
        return !source.m_269533_(DamageTypeTags.f_268738_) && !source.m_269533_(AetherTags.DamageTypes.IS_COLD);
    }

    protected SoundEvent getInteractSound() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SUN_SPIRIT_INTERACT.get();
    }

    protected SoundEvent getActivateSound() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SUN_SPIRIT_ACTIVATE.get();
    }

    protected SoundEvent getShootFireSound() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SUN_SPIRIT_SHOOT_FIRE.get();
    }

    protected SoundEvent getShootIceSound() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SUN_SPIRIT_SHOOT_ICE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AetherSoundEvents.ENTITY_SUN_SPIRIT_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SUN_SPIRIT_DEATH.get();
    }

    protected float m_6121_() {
        return 3.0f;
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_20068_() {
        return true;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.addBossSaveData(tag);
        tag.m_128405_("ChatLine", this.chatLine);
        tag.m_128347_("OffsetX", this.origin.m_7096_() - this.m_20185_());
        tag.m_128347_("OffsetY", this.origin.m_7098_() - this.m_20186_());
        tag.m_128347_("OffsetZ", this.origin.m_7094_() - this.m_20189_());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.readBossSaveData(tag);
        if (tag.m_128441_("ChatLine")) {
            this.chatLine = tag.m_128451_("ChatLine");
        }
        if (tag.m_128441_("OffsetX")) {
            double offsetX = this.m_20185_() + tag.m_128459_("OffsetX");
            double offsetY = this.m_20186_() + tag.m_128459_("OffsetY");
            double offsetZ = this.m_20189_() + tag.m_128459_("OffsetZ");
            this.origin = new Vec3(offsetX, offsetY, offsetZ);
        } else {
            this.origin = this.m_20182_();
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        CompoundTag tag = new CompoundTag();
        this.addBossSaveData(tag);
        buffer.m_130079_(tag);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        CompoundTag tag = additionalData.m_130260_();
        if (tag != null) {
            this.readBossSaveData(tag);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static class DoNothingGoal
    extends Goal {
        private final SunSpirit sunSpirit;

        public DoNothingGoal(SunSpirit sunSpirit) {
            this.sunSpirit = sunSpirit;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return !this.sunSpirit.isBossFight();
        }

        public void m_8056_() {
            this.sunSpirit.m_20256_(Vec3.f_82478_);
            this.sunSpirit.m_6034_(this.sunSpirit.origin.m_7096_(), this.sunSpirit.origin.m_7098_(), this.sunSpirit.origin.m_7094_());
        }
    }

    public static class SunSpiritLookGoal
    extends LookAtPlayerGoal {
        public SunSpiritLookGoal(Mob mob, Class<? extends LivingEntity> lookAtType, float lookDistance, float probability) {
            this(mob, lookAtType, lookDistance, probability, false);
        }

        public SunSpiritLookGoal(Mob mob, Class<? extends LivingEntity> lookAtType, float lookDistance, float probability, boolean onlyHorizontal) {
            super(mob, lookAtType, lookDistance, probability, onlyHorizontal);
            TargetingConditions conditions = lookAtType == Player.class ? TargetingConditions.m_148353_().m_26893_().m_26883_((double)lookDistance).m_26888_(entity -> EntitySelector.m_20431_((Entity)mob).test(entity)) : TargetingConditions.m_148353_().m_26893_().m_26883_((double)lookDistance);
            ((LookAtPlayerGoalAccessor)((Object)this)).aether$setLookAtContext(conditions);
        }
    }

    public static class ShootFireballGoal
    extends Goal {
        private final SunSpirit sunSpirit;
        private int shootCrystalInterval;
        private int crystalCount;

        public ShootFireballGoal(SunSpirit sunSpirit) {
            this.sunSpirit = sunSpirit;
            this.shootCrystalInterval = 50;
            this.crystalCount = 5;
        }

        public boolean m_8036_() {
            return this.sunSpirit.isBossFight() && --this.shootCrystalInterval <= 0;
        }

        public void m_8056_() {
            AbstractCrystal crystal;
            if (--this.crystalCount <= 0) {
                crystal = new IceCrystal(this.sunSpirit.m_9236_(), (Entity)this.sunSpirit);
                this.crystalCount = 5;
                this.sunSpirit.m_5496_(this.sunSpirit.getShootIceSound(), 3.0f, this.sunSpirit.m_9236_().m_213780_().m_188501_() - this.sunSpirit.m_9236_().m_213780_().m_188501_() * 0.2f + 1.2f);
            } else {
                crystal = new FireCrystal(this.sunSpirit.m_9236_(), (Entity)this.sunSpirit);
                this.sunSpirit.m_5496_(this.sunSpirit.getShootFireSound(), 3.0f, this.sunSpirit.m_9236_().m_213780_().m_188501_() - this.sunSpirit.m_9236_().m_213780_().m_188501_() * 0.2f + 1.2f);
            }
            this.sunSpirit.m_9236_().m_7967_((Entity)crystal);
            this.shootCrystalInterval = 50;
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public static class SummonFireGoal
    extends Goal {
        private final SunSpirit sunSpirit;
        private int summonFireInterval;

        public SummonFireGoal(SunSpirit sunSpirit) {
            this.sunSpirit = sunSpirit;
            this.summonFireInterval = 35;
        }

        public boolean m_8036_() {
            return this.sunSpirit.isBossFight() && --this.summonFireInterval <= 0;
        }

        public void m_8056_() {
            BlockPos pos = BlockPos.m_274561_((double)this.sunSpirit.m_20185_(), (double)this.sunSpirit.m_20186_(), (double)this.sunSpirit.m_20189_());
            for (int i = 0; i <= 3; ++i) {
                if (this.sunSpirit.m_9236_().m_46859_(pos) && !this.sunSpirit.m_9236_().m_46859_(pos.m_7495_())) {
                    this.sunSpirit.m_9236_().m_7731_(pos, Blocks.f_50083_.m_49966_(), 11);
                    break;
                }
                pos = pos.m_7495_();
            }
            this.summonFireInterval = 35;
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public static class FlyAroundGoal
    extends Goal {
        private final SunSpirit sunSpirit;
        private float rotation;
        private int courseChangeTimer;

        public FlyAroundGoal(SunSpirit sunSpirit) {
            this.sunSpirit = sunSpirit;
            this.rotation = sunSpirit.f_19796_.m_188501_() * 360.0f;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public void m_8037_() {
            boolean changedCourse = this.outOfBounds();
            double x = (double)Mth.m_14031_((float)(this.rotation * ((float)Math.PI / 180))) * this.sunSpirit.m_21133_(Attributes.f_22279_) * this.sunSpirit.speedModifier;
            double z = (double)(-Mth.m_14089_((float)(this.rotation * ((float)Math.PI / 180)))) * this.sunSpirit.m_21133_(Attributes.f_22279_) * this.sunSpirit.speedModifier;
            this.sunSpirit.m_20334_(x, 0.0, z);
            if (changedCourse || ++this.courseChangeTimer >= 20) {
                if (this.sunSpirit.m_217043_().m_188503_(3) == 0) {
                    this.rotation += this.sunSpirit.m_217043_().m_188501_() - this.sunSpirit.m_217043_().m_188501_() * 60.0f;
                }
                this.rotation = Mth.m_14177_((float)this.rotation);
                this.courseChangeTimer = 0;
            }
        }

        protected boolean outOfBounds() {
            boolean flag = false;
            if (this.sunSpirit.m_20184_().m_7096_() >= 0.0 && this.sunSpirit.m_20185_() >= this.sunSpirit.origin.m_7096_() + (double)this.sunSpirit.xMax || this.sunSpirit.m_20184_().m_7096_() <= 0.0 && this.sunSpirit.m_20185_() <= this.sunSpirit.origin.m_7096_() - (double)this.sunSpirit.xMax) {
                this.rotation = 360.0f - this.rotation;
                flag = true;
            }
            if (this.sunSpirit.m_20184_().m_7094_() >= 0.0 && this.sunSpirit.m_20189_() >= this.sunSpirit.origin.m_7094_() + (double)this.sunSpirit.zMax || this.sunSpirit.m_20184_().m_7094_() <= 0.0 && this.sunSpirit.m_20189_() <= this.sunSpirit.origin.m_7094_() - (double)this.sunSpirit.zMax) {
                this.rotation = 180.0f - this.rotation;
                flag = true;
            }
            return flag;
        }

        public boolean m_8036_() {
            return this.sunSpirit.isBossFight();
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

