/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block.utility;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.blockentity.SunAltarBlockEntity;
import com.aetherteam.aether.capability.AetherCapabilities;
import com.aetherteam.aether.capability.time.AetherTime;
import com.aetherteam.aether.command.SunAltarWhitelist;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.clientbound.OpenSunAltarPacket;
import com.aetherteam.nitrogen.network.PacketRelay;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.simple.SimpleChannel;

public class SunAltarBlock
extends BaseEntityBlock {
    public SunAltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SunAltarBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.m_5776_()) {
            if (((Boolean)AetherConfig.SERVER.sun_altar_whitelist.get()).booleanValue() && !player.m_20310_(4) && !SunAltarWhitelist.INSTANCE.isWhiteListed(player.m_36316_())) {
                player.m_5661_((Component)Component.m_237115_((String)"aether.sun_altar.no_permission"), true);
            } else if (((List)AetherConfig.SERVER.sun_altar_dimensions.get()).contains(level.m_46472_().m_135782_().toString())) {
                Optional aetherTimeOptional = level.getCapability(AetherCapabilities.AETHER_TIME_CAPABILITY).resolve();
                if (aetherTimeOptional.isPresent()) {
                    if (!((AetherTime)aetherTimeOptional.get()).getEternalDay()) {
                        this.openScreen(level, pos, player, 72000);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"aether.sun_altar.in_control"), true);
                    }
                } else {
                    this.openScreen(level, pos, player, 24000);
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"aether.sun_altar.no_power"), true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected void openScreen(Level level, BlockPos pos, Player player, int timeScale) {
        if (!level.m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof SunAltarBlockEntity) {
                SunAltarBlockEntity sunAltar = (SunAltarBlockEntity)blockEntity;
                PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new OpenSunAltarPacket(sunAltar.m_7755_(), timeScale), (ServerPlayer)serverPlayer);
            }
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof SunAltarBlockEntity) {
            SunAltarBlockEntity sunAltar = (SunAltarBlockEntity)blockEntity;
            sunAltar.setCustomName(stack.m_41786_());
            sunAltar.m_6596_();
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }
}

