/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.sound;

import com.mrh0.createaddition.index.CASounds;
import com.mrh0.createaddition.sound.CASoundScape;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;

public class CASoundScapes {
    static final int MAX_AMBIENT_SOURCE_DISTANCE = 16;
    static final int UPDATE_INTERVAL = 5;
    static final int SOUND_VOLUME_ARG_MAX = 15;
    private static final Map<AmbienceGroup, Map<PitchGroup, Set<BlockPos>>> counter = new IdentityHashMap<AmbienceGroup, Map<PitchGroup, Set<BlockPos>>>();
    private static final Map<Pair<AmbienceGroup, PitchGroup>, CASoundScape> activeSounds = new HashMap<Pair<AmbienceGroup, PitchGroup>, CASoundScape>();

    private static CASoundScape dynamo(float pitch, AmbienceGroup group) {
        return new CASoundScape(pitch, group).continuous((SoundEvent)CASounds.ELECTRIC_MOTOR_BUZZ.get(), 0.75f, 1.0f);
    }

    private static CASoundScape tesla(float pitch, AmbienceGroup group) {
        return new CASoundScape(pitch, group).continuous((SoundEvent)CASounds.ELECTRIC_CHARGE.get(), 1.0f, 1.0f);
    }

    private static CASoundScape charge(float pitch, AmbienceGroup group) {
        return new CASoundScape(pitch, group).continuous((SoundEvent)CASounds.ELECTRIC_CHARGE.get(), 0.2f, 1.0f);
    }

    public static void play(AmbienceGroup group, BlockPos pos, float pitch) {
        if (!((Boolean)AllConfigs.client().enableAmbientSounds.get()).booleanValue()) {
            return;
        }
        if (!CASounds.ELECTRIC_MOTOR_BUZZ.isPresent() || !CASounds.ELECTRIC_CHARGE.isPresent()) {
            return;
        }
        if (!CASoundScapes.outOfRange(pos)) {
            CASoundScapes.addSound(group, pos, pitch);
        }
    }

    public static void tick() {
        activeSounds.values().forEach(CASoundScape::tick);
        if (AnimationTickHolder.getTicks() % 5 != 0) {
            return;
        }
        boolean disable = (Boolean)AllConfigs.client().enableAmbientSounds.get() == false;
        Iterator<Map.Entry<Pair<AmbienceGroup, PitchGroup>, CASoundScape>> iterator = activeSounds.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Pair<AmbienceGroup, PitchGroup>, CASoundScape> entry = iterator.next();
            Pair<AmbienceGroup, PitchGroup> key = entry.getKey();
            CASoundScape value = entry.getValue();
            if (!disable && CASoundScapes.getSoundCount((AmbienceGroup)((Object)key.getFirst()), (PitchGroup)((Object)key.getSecond())) != 0) continue;
            value.remove();
            iterator.remove();
        }
        counter.values().forEach(m -> m.values().forEach(Set::clear));
    }

    private static void addSound(AmbienceGroup group, BlockPos pos, float pitch) {
        PitchGroup groupFromPitch = CASoundScapes.getGroupFromPitch(pitch);
        Set set = counter.computeIfAbsent(group, ag -> new IdentityHashMap()).computeIfAbsent(groupFromPitch, pg -> new HashSet());
        set.add(pos);
        Pair pair = Pair.of((Object)((Object)group), (Object)((Object)groupFromPitch));
        activeSounds.computeIfAbsent((Pair<AmbienceGroup, PitchGroup>)pair, $ -> {
            CASoundScape soundScape = group.instantiate(pitch);
            soundScape.play();
            return soundScape;
        });
    }

    public static void invalidateAll() {
        counter.clear();
        activeSounds.forEach(($, sound) -> sound.remove());
        activeSounds.clear();
    }

    protected static boolean outOfRange(BlockPos pos) {
        return !CASoundScapes.getCameraPos().m_123314_((Vec3i)pos, 16.0);
    }

    protected static BlockPos getCameraPos() {
        Entity renderViewEntity = Minecraft.m_91087_().f_91075_;
        if (renderViewEntity == null) {
            return BlockPos.f_121853_;
        }
        return renderViewEntity.m_20183_();
    }

    public static int getSoundCount(AmbienceGroup group, PitchGroup pitchGroup) {
        return CASoundScapes.getAllLocations(group, pitchGroup).size();
    }

    public static Set<BlockPos> getAllLocations(AmbienceGroup group, PitchGroup pitchGroup) {
        return counter.getOrDefault((Object)group, Collections.emptyMap()).getOrDefault((Object)pitchGroup, Collections.emptySet());
    }

    public static PitchGroup getGroupFromPitch(float pitch) {
        if ((double)pitch < 0.7) {
            return PitchGroup.VERY_LOW;
        }
        if ((double)pitch < 0.9) {
            return PitchGroup.LOW;
        }
        if ((double)pitch < 1.1) {
            return PitchGroup.NORMAL;
        }
        if ((double)pitch < 1.3) {
            return PitchGroup.HIGH;
        }
        return PitchGroup.VERY_HIGH;
    }

    public static enum AmbienceGroup {
        DYNAMO(CASoundScapes::dynamo),
        TESLA(CASoundScapes::tesla),
        CHARGE(CASoundScapes::charge);

        private final BiFunction<Float, AmbienceGroup, CASoundScape> factory;

        private AmbienceGroup(BiFunction<Float, AmbienceGroup, CASoundScape> factory) {
            this.factory = factory;
        }

        CASoundScape instantiate(float pitch) {
            return this.factory.apply(Float.valueOf(pitch), this);
        }
    }

    public static enum PitchGroup {
        VERY_LOW,
        LOW,
        NORMAL,
        HIGH,
        VERY_HIGH;

    }
}

