/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.research;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchBranch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.effects.IResearchEffect;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.Network;
import com.minecolonies.core.research.GlobalResearchBranch;
import com.minecolonies.core.research.GlobalResearchTreeMessage;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalResearchTree
implements IGlobalResearchTree {
    private final Map<ResourceLocation, Map<ResourceLocation, IGlobalResearch>> researchTree = new HashMap<ResourceLocation, Map<ResourceLocation, IGlobalResearch>>();
    private final Map<ResourceLocation, IGlobalResearchBranch> branchDatas = new HashMap<ResourceLocation, IGlobalResearchBranch>();
    private final List<ResourceLocation> reloadableResearch = new ArrayList<ResourceLocation>();
    private final Set<IGlobalResearch> autostartResearch = new HashSet<IGlobalResearch>();
    private final Map<ResourceLocation, Set<IGlobalResearch>> researchEffectsIds = new HashMap<ResourceLocation, Set<IGlobalResearch>>();

    @Override
    public IGlobalResearch getResearch(ResourceLocation branch, ResourceLocation id) {
        return this.researchTree.get(branch).get(id);
    }

    @Override
    @Nullable
    public IGlobalResearch getResearch(ResourceLocation id) {
        for (Map.Entry<ResourceLocation, Map<ResourceLocation, IGlobalResearch>> branch : this.researchTree.entrySet()) {
            if (!branch.getValue().containsKey(id)) continue;
            return branch.getValue().get(id);
        }
        return null;
    }

    @Override
    public boolean hasResearch(ResourceLocation branch, ResourceLocation id) {
        return this.researchTree.containsKey(branch) && this.researchTree.get(branch).containsKey(id);
    }

    @Override
    public boolean hasResearch(ResourceLocation id) {
        for (Map.Entry<ResourceLocation, Map<ResourceLocation, IGlobalResearch>> branch : this.researchTree.entrySet()) {
            if (!branch.getValue().containsKey(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addResearch(ResourceLocation branch, IGlobalResearch research, boolean isReloadedWithWorld) {
        Map<Object, Object> branchMap = this.researchTree.containsKey(branch) ? this.researchTree.get(branch) : new HashMap();
        if (branchMap.containsKey(research.getId())) {
            Log.getLogger().error("Duplicate research key:" + String.valueOf(research.getId()));
        }
        branchMap.put(research.getId(), research);
        this.researchTree.put(branch, branchMap);
        if (isReloadedWithWorld) {
            this.reloadableResearch.add(research.getId());
        }
        for (IResearchEffect<?> effect : research.getEffects()) {
            this.researchEffectsIds.computeIfAbsent(effect.getId(), id -> new HashSet()).add(research);
        }
        if (research.isAutostart()) {
            this.autostartResearch.add(research);
        }
    }

    @Override
    public void addBranchData(ResourceLocation branchId, IGlobalResearchBranch branchData) {
        this.branchDatas.put(branchId, branchData);
    }

    @Override
    public Set<IGlobalResearch> getResearchForEffect(ResourceLocation id) {
        return this.researchEffectsIds.get(id);
    }

    @Override
    public boolean hasResearchEffect(ResourceLocation id) {
        return this.researchEffectsIds.get(id) != null;
    }

    @Override
    public List<ResourceLocation> getBranches() {
        return new ArrayList<ResourceLocation>(this.researchTree.keySet());
    }

    @Override
    public IGlobalResearchBranch getBranchData(ResourceLocation id) {
        if (this.branchDatas.containsKey(id)) {
            return this.branchDatas.get(id);
        }
        return new GlobalResearchBranch(id);
    }

    @Override
    public List<ResourceLocation> getPrimaryResearch(ResourceLocation branch) {
        if (!this.researchTree.containsKey(branch)) {
            return Collections.emptyList();
        }
        return this.researchTree.get(branch).values().stream().filter(research -> research.getParent().m_135815_().isEmpty()).sorted(Comparator.comparing(IGlobalResearch::getId)).map(IGlobalResearch::getId).collect(Collectors.toList());
    }

    @Override
    public void reset() {
        for (ResourceLocation reset : this.reloadableResearch) {
            for (Map.Entry<ResourceLocation, Map<ResourceLocation, IGlobalResearch>> entry : this.researchTree.entrySet()) {
                entry.getValue().remove(reset);
            }
            for (Set set : this.researchEffectsIds.values()) {
                set.removeIf(r -> r.getId().equals((Object)reset));
            }
        }
        this.reloadableResearch.clear();
        this.autostartResearch.clear();
        this.branchDatas.clear();
        Iterator<Map.Entry<ResourceLocation, Map<ResourceLocation, IGlobalResearch>>> iterator = this.researchTree.entrySet().iterator();
        while (this.researchTree.entrySet().size() > 0 && iterator.hasNext()) {
            if (iterator.next().getValue().size() != 0) continue;
            iterator.remove();
        }
    }

    @Override
    public boolean isResearchRequirementsFulfilled(List<IResearchRequirement> requirements, IColony colony) {
        if (requirements == null || requirements.isEmpty()) {
            return true;
        }
        for (IResearchRequirement requirement : requirements) {
            if (requirement.isFulfilled(colony)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void sendGlobalResearchTreePackets(ServerPlayer player) {
        FriendlyByteBuf researchTreeFriendlyByteBuf = new FriendlyByteBuf(Unpooled.buffer());
        this.serializeNetworkData(researchTreeFriendlyByteBuf);
        Network.getNetwork().sendToPlayer(new GlobalResearchTreeMessage(researchTreeFriendlyByteBuf), player);
    }

    public void serializeNetworkData(FriendlyByteBuf buf) {
        buf.m_130130_(this.researchTree.size());
        for (Map<ResourceLocation, IGlobalResearch> map : this.researchTree.values()) {
            buf.m_130130_(map.size());
            for (IGlobalResearch research : map.values()) {
                StandardFactoryController.getInstance().serialize(buf, research);
            }
        }
        for (Map.Entry entry : this.branchDatas.entrySet()) {
            buf.m_130085_((ResourceLocation)entry.getKey());
            buf.m_130079_(((IGlobalResearchBranch)entry.getValue()).writeToNBT());
        }
    }

    @Override
    public IMessage handleGlobalResearchTreeMessage(FriendlyByteBuf buf) {
        this.researchTree.clear();
        this.branchDatas.clear();
        this.researchEffectsIds.clear();
        for (int branchNum = buf.m_130242_(); branchNum > 0; --branchNum) {
            for (int researchNum = buf.m_130242_(); researchNum > 0; --researchNum) {
                IGlobalResearch newResearch = (IGlobalResearch)StandardFactoryController.getInstance().deserialize(buf);
                this.addResearch(newResearch.getBranch(), newResearch, true);
            }
        }
        for (int i = 0; i < this.researchTree.entrySet().size(); ++i) {
            ResourceLocation branchId = buf.m_130281_();
            this.branchDatas.put(branchId, new GlobalResearchBranch(buf.m_130260_()));
        }
        return null;
    }

    @Override
    public List<IResearchEffect<?>> getEffectsForResearch(@NotNull ResourceLocation id) {
        for (ResourceLocation branch : this.getBranches()) {
            IGlobalResearch r = this.getResearch(branch, id);
            if (r == null) continue;
            return r.getEffects();
        }
        return new ArrayList();
    }

    @Override
    public Set<IGlobalResearch> getAutostartResearches() {
        return this.autostartResearch;
    }

    @Override
    public List<ItemStorage> getResearchResetCosts() {
        ArrayList<ItemStorage> outputList = new ArrayList<ItemStorage>();
        for (String itemId : (List)MinecoloniesAPIProxy.getInstance().getConfig().getServer().researchResetCost.get()) {
            Item item;
            ItemStack stack;
            int tagIndex = itemId.indexOf("{");
            String tag = tagIndex > 0 ? itemId.substring(tagIndex) : null;
            itemId = tagIndex > 0 ? itemId.substring(0, tagIndex) : itemId;
            String[] split = itemId.split(":");
            if (split.length != 2) {
                if (split.length == 1) {
                    String[] tempArray = new String[]{"minecraft", split[0]};
                    split = tempArray;
                } else if (split.length > 3) {
                    Log.getLogger().error("Unable to parse Research Reset Cost definition: " + itemId);
                }
            }
            if ((stack = new ItemStack((ItemLike)(item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0], split[1]))))).m_41619_()) {
                Log.getLogger().warn("Unable to parse Research Reset Cost definition: " + itemId);
                continue;
            }
            if (tag != null) {
                try {
                    stack.m_41751_(TagParser.m_129359_((String)tag));
                    outputList.add(new ItemStorage(stack, false, false));
                }
                catch (CommandSyntaxException parseException) {
                    Log.getLogger().error("Unable to parse Research Reset Cost definition: " + itemId);
                }
                continue;
            }
            outputList.add(new ItemStorage(stack, false, true));
        }
        return outputList;
    }
}

