/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.fields;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildingextensions.registry.BuildingExtensionRegistries;
import com.minecolonies.core.colony.buildingextensions.FarmField;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class FarmFieldUpdateSeedMessage
extends AbstractColonyServerMessage {
    private ItemStack newSeed;
    private BlockPos position;

    public FarmFieldUpdateSeedMessage() {
    }

    public FarmFieldUpdateSeedMessage(@NotNull IColony colony, ItemStack newSeed, BlockPos position) {
        super(colony);
        this.newSeed = newSeed;
        this.position = position;
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        if (!isLogicalServer || ctxIn.getSender() == null) {
            return;
        }
        colony.getBuildingManager().getBuildingExtension(f -> f.getBuildingExtensionType().equals(BuildingExtensionRegistries.farmField.get()) && f.getPosition().equals((Object)this.position)).map(m -> (FarmField)m).ifPresent(field -> field.setSeed(this.newSeed));
    }

    @Override
    public void toBytesOverride(FriendlyByteBuf buf) {
        buf.m_130055_(this.newSeed);
        buf.m_130064_(this.position);
    }

    @Override
    public void fromBytesOverride(FriendlyByteBuf buf) {
        this.newSeed = buf.m_130267_();
        this.position = buf.m_130135_();
    }
}

