/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.Network;
import com.minecolonies.core.items.AbstractItemScroll;
import com.minecolonies.core.network.messages.client.VanillaParticleMessage;
import com.minecolonies.core.util.TeleportHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemScrollColonyAreaTP
extends AbstractItemScroll {
    public ItemScrollColonyAreaTP(Item.Properties properties) {
        super("scroll_area_tp", properties);
    }

    @Override
    public int m_8105_(ItemStack itemStack) {
        return 64;
    }

    @Override
    protected ItemStack onItemUseSuccess(ItemStack itemStack, Level world, ServerPlayer player) {
        if (world.f_46441_.m_188503_(10) == 0) {
            player.m_5661_((Component)Component.m_237115_((String)("minecolonies.scroll.failed" + (world.f_46441_.m_188503_(10) + 1))).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
            itemStack.m_41774_(1);
            if (!ItemStackUtils.isEmpty(itemStack)) {
                player.m_7197_(itemStack.m_41777_(), true, false);
                itemStack.m_41764_(0);
            }
            for (ServerPlayer sPlayer : this.getAffectedPlayers(player)) {
                SoundUtils.playSoundForPlayer(sPlayer, SoundEvents.f_11868_, 0.3f, 1.0f);
            }
        } else {
            for (ServerPlayer sPlayer : this.getAffectedPlayers(player)) {
                this.doTeleport(sPlayer, this.getColony(itemStack), itemStack);
                SoundUtils.playSoundForPlayer(sPlayer, SoundEvents.f_12496_, 0.1f, 1.0f);
            }
            itemStack.m_41774_(1);
        }
        return itemStack;
    }

    @Override
    protected boolean needsColony() {
        return true;
    }

    protected void doTeleport(ServerPlayer player, IColony colony, ItemStack stack) {
        TeleportHelper.colonyTeleport(player, colony);
    }

    public void m_5929_(Level worldIn, LivingEntity entity, ItemStack stack, int count) {
        if (!worldIn.f_46443_ && worldIn.m_46467_() % 5L == 0L && entity instanceof Player) {
            ServerPlayer sPlayer = (ServerPlayer)entity;
            for (Entity entity2 : this.getAffectedPlayers(sPlayer)) {
                Network.getNetwork().sendToTrackingEntity(new VanillaParticleMessage(entity2.m_20185_(), entity2.m_20186_(), entity2.m_20189_(), ParticleTypes.f_123751_), entity2);
            }
            Network.getNetwork().sendToPlayer(new VanillaParticleMessage(sPlayer.m_20185_(), sPlayer.m_20186_(), sPlayer.m_20189_(), ParticleTypes.f_123751_), sPlayer);
        }
    }

    private List<ServerPlayer> getAffectedPlayers(ServerPlayer user) {
        return user.f_19853_.m_45976_(ServerPlayer.class, user.m_20191_().m_82377_(10.0, 2.0, 10.0));
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        MutableComponent guiHint = Component.m_237115_((String)"item.minecolonies.scroll_area_tp.tip");
        guiHint.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN));
        tooltip.add((Component)guiHint);
        MutableComponent colonyDesc = Component.m_237115_((String)"item.minecolonies.scroll.colony.none");
        IColony colony = this.getColonyView(stack);
        if (colony != null) {
            colonyDesc = Component.m_237113_((String)colony.getName());
        }
        MutableComponent guiHint2 = Component.m_237110_((String)"item.minecolonies.scroll.colony.tip", (Object[])new Object[]{colonyDesc});
        guiHint2.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD));
        tooltip.add((Component)guiHint2);
    }
}

