/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintUtil;
import com.ldtteam.structurize.items.AbstractItemWithPosSelector;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.core.client.gui.WindowSchematicAnalyzer;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class ItemScanAnalyzer
extends AbstractItemWithPosSelector {
    public static String TEMP_SCAN = "selection.blueprint";
    public static String LAST_TIME = "lastworldtime";
    private static final int TIMEOUT_DELAY = 2400;
    private static BlockPos lastPos = BlockPos.f_121853_;
    private static BlockPos lastPos2 = BlockPos.f_121853_;
    public static Blueprint blueprint = null;

    public ItemScanAnalyzer(@NotNull String name, Item.Properties properties) {
        super(properties.m_41503_(0).setNoRepair().m_41497_(Rarity.UNCOMMON));
    }

    public ItemScanAnalyzer(Item.Properties properties) {
        super(properties);
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        this.checkTimeout(player.m_21205_(), worldIn);
        boolean result = super.m_6777_(state, worldIn, pos, player);
        this.openAreaBox(player.m_21205_());
        return result;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        this.checkTimeout(context.m_43722_(), context.m_43725_());
        InteractionResult result = super.m_6225_(context);
        this.openAreaBox(context.m_43722_());
        return result;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        this.checkTimeout(playerIn.m_21120_(handIn), worldIn);
        ItemStack itemstack = playerIn.m_21120_(handIn);
        CompoundTag compound = itemstack.m_41784_();
        BlockPos firstPos = null;
        if (compound.m_128441_("structurize:start_pos")) {
            firstPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("structurize:start_pos"));
        }
        BlockPos secondPos = null;
        if (compound.m_128441_("structurize:end_pos")) {
            secondPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("structurize:end_pos"));
        }
        return new InteractionResultHolder(this.onAirRightClick(firstPos, secondPos, worldIn, playerIn, itemstack), (Object)itemstack);
    }

    public InteractionResult onAirRightClick(BlockPos start, BlockPos end, Level worldIn, Player playerIn, ItemStack itemStack) {
        if (worldIn.f_46443_) {
            if (!(start == null || end == null || lastPos.equals((Object)start) && lastPos2.equals((Object)end))) {
                lastPos = start;
                lastPos2 = end;
                blueprint = ItemScanAnalyzer.saveStructure(worldIn, playerIn, new AABB((BlockPos)ItemScanAnalyzer.getBounds((ItemStack)itemStack).m_14418_(), (BlockPos)ItemScanAnalyzer.getBounds((ItemStack)itemStack).m_14419_()));
            }
            new WindowSchematicAnalyzer().open();
        }
        return InteractionResult.SUCCESS;
    }

    public AbstractItemWithPosSelector getRegisteredItemInstance() {
        return (AbstractItemWithPosSelector)ModItems.scanAnalyzer;
    }

    private void openAreaBox(ItemStack tool) {
        CompoundTag tag = tool.m_41784_();
        if (tag.m_128441_("structurize:start_pos") && tag.m_128441_("structurize:end_pos")) {
            BlockPos start = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("structurize:start_pos"));
            BlockPos end = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("structurize:end_pos"));
            RenderingCache.queue((String)"analyzer", (BoxPreviewData)new BoxPreviewData(start, end, Optional.empty()));
        }
    }

    protected void checkTimeout(ItemStack stack, Level level) {
        if (stack == null || level == null) {
            return;
        }
        if (stack.m_41784_().m_128441_(LAST_TIME)) {
            long prevTime = stack.m_41784_().m_128454_(LAST_TIME);
            if (level.m_46467_() - prevTime > 2400L) {
                stack.m_41784_().m_128473_("structurize:start_pos");
                stack.m_41784_().m_128473_("structurize:end_pos");
            }
        }
        stack.m_41784_().m_128356_(LAST_TIME, level.m_46467_());
    }

    public static Blueprint saveStructure(Level world, Player player, AABB box) {
        if (box.m_82362_() * box.m_82376_() * box.m_82385_() > (double)((Integer)Structurize.getConfig().getServer().schematicBlockLimit.get()).intValue()) {
            player.m_5661_((Component)Component.m_237110_((String)"item.sceptersteel.toobig", (Object[])new Object[]{Structurize.getConfig().getServer().schematicBlockLimit.get()}), false);
            return null;
        }
        String fileName = TEMP_SCAN;
        BlockPos zero = new BlockPos((int)box.f_82288_, (int)box.f_82289_, (int)box.f_82290_);
        Blueprint bp = BlueprintUtil.createBlueprint((Level)world, (BlockPos)zero, (boolean)false, (short)((short)(box.m_82362_() + 1.0)), (short)((short)(box.m_82376_() + 1.0)), (short)((short)(box.m_82385_() + 1.0)), (String)fileName, Optional.empty());
        return bp;
    }
}

