/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.minecolonies.api.items.CheckedNbtKey;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.CraftingUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ItemNbtCalculator
implements DataProvider {
    private final PackOutput packOutput;
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;

    public ItemNbtCalculator(@NotNull PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        this.packOutput = packOutput;
        this.lookupProvider = lookupProvider;
    }

    @NotNull
    public String m_6055_() {
        return "ItemNBTCalculator";
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
        HolderLookup.Provider provider = this.lookupProvider.join();
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        CreativeModeTab.ItemDisplayParameters tempDisplayParams = new CreativeModeTab.ItemDisplayParameters(FeatureFlags.f_244280_.m_247355_(), false, provider);
        CraftingUtils.forEachCreativeTabItems(tempDisplayParams, (tab, stacks) -> {
            for (ItemStack item : stacks) {
                BlockItem blockItem;
                Block patt2524$temp;
                Item patt2469$temp = item.m_41720_();
                if (patt2469$temp instanceof BlockItem && (patt2524$temp = (blockItem = (BlockItem)patt2469$temp).m_40614_()) instanceof IMateriallyTexturedBlock) {
                    IMateriallyTexturedBlock texturedBlock = (IMateriallyTexturedBlock)patt2524$temp;
                    CompoundTag tag = item.m_41782_() ? item.m_41783_() : new CompoundTag();
                    CompoundTag textureData = new CompoundTag();
                    for (IMateriallyTexturedBlockComponent key : texturedBlock.getComponents()) {
                        textureData.m_128359_(key.getId().toString(), key.getDefault().m_204297_().m_205785_().m_135782_().toString());
                    }
                    tag.m_128365_("textureData", (Tag)textureData);
                    ItemStack copy = item.m_41777_();
                    copy.m_41751_(tag);
                    listBuilder.add((Object)copy);
                    continue;
                }
                listBuilder.add((Object)item);
            }
        });
        ImmutableList allStacks = listBuilder.build();
        TreeMap<String, Set> keyMapping = new TreeMap<String, Set>();
        for (ItemStack stack : allStacks) {
            HashSet<String> keys;
            ResourceLocation resourceLocation = ((ResourceKey)stack.m_220173_().m_203543_().get()).m_135782_();
            CompoundTag tag = stack.m_41782_() && !stack.m_204117_(ModTags.ignoreNBT) ? stack.m_41783_() : new CompoundTag();
            HashSet<String> hashSet = keys = tag.m_128456_() ? new HashSet<String>() : new HashSet(tag.m_128431_());
            if (stack.m_41720_() instanceof DyeableLeatherItem) {
                keys.add("display");
            }
            if (stack.m_41792_()) {
                keys.add("Enchantments");
            }
            if (stack.isRepairable()) {
                keys.add("RepairCost");
            }
            keys.remove("Damage");
            HashSet<CheckedNbtKey> keyObjectList = new HashSet<CheckedNbtKey>();
            for (String key2 : keys) {
                keyObjectList.add(ItemNbtCalculator.createKeyFromNbt(key2, tag));
            }
            if (keyMapping.containsKey(resourceLocation.toString())) {
                Set list = (Set)keyMapping.get(resourceLocation.toString());
                list.addAll(keyObjectList);
                keyMapping.put(resourceLocation.toString(), list);
                continue;
            }
            keyMapping.put(resourceLocation.toString(), keyObjectList);
        }
        Path path = this.packOutput.m_245269_(PackOutput.Target.DATA_PACK, "compatibility").m_245527_(new ResourceLocation("minecolonies", "itemnbtmatching"), "json");
        JsonArray jsonArray = new JsonArray();
        for (Map.Entry entry : keyMapping.entrySet()) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", (String)entry.getKey());
            if (!((Set)entry.getValue()).isEmpty()) {
                JsonArray subArray = new JsonArray();
                ((Set)entry.getValue()).forEach(key -> subArray.add((JsonElement)ItemNbtCalculator.serializeKeyToJson(key)));
                jsonObject.add("checkednbtkeys", (JsonElement)subArray);
            }
            jsonArray.add((JsonElement)jsonObject);
        }
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)jsonArray, (Path)path);
    }

    public static JsonObject serializeKeyToJson(CheckedNbtKey keyObject) {
        JsonObject obj = new JsonObject();
        obj.addProperty("key", keyObject.key);
        if (!keyObject.children.isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            keyObject.children.forEach(child -> jsonArray.add((JsonElement)ItemNbtCalculator.serializeKeyToJson(child)));
            obj.add("children", (JsonElement)jsonArray);
        }
        return obj;
    }

    public static void serializeKeyToBuffer(CheckedNbtKey keyObject, FriendlyByteBuf buf) {
        buf.m_130070_(keyObject.key);
        if (!keyObject.children.isEmpty()) {
            FriendlyByteBuf childBuf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeInt(keyObject.children.size());
            for (CheckedNbtKey child : keyObject.children) {
                ItemNbtCalculator.serializeKeyToBuffer(child, childBuf);
            }
            buf.writeBytes((ByteBuf)childBuf);
        } else {
            buf.writeInt(0);
        }
    }

    public static CheckedNbtKey deSerializeKeyFromBuffer(FriendlyByteBuf buf) {
        String key = buf.m_130277_();
        HashSet<CheckedNbtKey> children = new HashSet<CheckedNbtKey>();
        int limit = buf.readInt();
        for (int i = 0; i < limit; ++i) {
            CheckedNbtKey keyFromBuffer = ItemNbtCalculator.deSerializeKeyFromBuffer(buf);
            children.add(keyFromBuffer);
        }
        return new CheckedNbtKey(key, children);
    }

    public static CheckedNbtKey createKeyFromNbt(String key, CompoundTag tag) {
        if (tag.m_128423_(key) instanceof CompoundTag) {
            CompoundTag subTag = tag.m_128469_(key);
            HashSet<CheckedNbtKey> set = new HashSet<CheckedNbtKey>();
            for (String subKey : subTag.m_128431_()) {
                CheckedNbtKey keyFromNbt = ItemNbtCalculator.createKeyFromNbt(subKey, subTag);
                set.add(keyFromNbt);
            }
            return new CheckedNbtKey(key, set);
        }
        return new CheckedNbtKey(key, Collections.emptySet());
    }

    public static CheckedNbtKey deserializeKeyFromJson(JsonObject jsonObject) {
        String key = jsonObject.get("key").getAsString();
        if (jsonObject.has("children")) {
            HashSet<CheckedNbtKey> children = new HashSet<CheckedNbtKey>();
            jsonObject.getAsJsonArray("children").forEach(child -> children.add(ItemNbtCalculator.deserializeKeyFromJson(child.getAsJsonObject())));
            return new CheckedNbtKey(key, children);
        }
        return new CheckedNbtKey(key, Collections.emptySet());
    }
}

