/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.entity.ai.workers.util.Tree;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathjobs.ISearchPathJob;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import com.minecolonies.core.entity.pathfinding.pathresults.TreePathResult;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class PathJobFindTree
extends AbstractPathJob
implements ISearchPathJob {
    private final List<ItemStorage> excludedTrees;
    private final IColony colony;
    private final BlockPos searchTowards;
    private final int dyntreesize;
    private AABB restrictionBox = null;

    public PathJobFindTree(Level world, @NotNull BlockPos start, BlockPos home, int range, List<ItemStorage> treesToCut, int dyntreesize, IColony colony, Mob entity) {
        super(world, start, range, (PathResult)new TreePathResult(), entity);
        this.excludedTrees = treesToCut;
        this.colony = colony;
        this.searchTowards = home;
        this.dyntreesize = dyntreesize;
    }

    public PathJobFindTree(Level world, @NotNull BlockPos start, BlockPos startRestriction, BlockPos endRestriction, BlockPos furthestRestriction, List<ItemStorage> excludedTrees, int dyntreesize, IColony colony, Mob entity) {
        super(world, start, (int)(BlockPosUtil.dist(entity.m_20183_(), (startRestriction.m_123341_() + endRestriction.m_123341_()) / 2, (startRestriction.m_123342_() + endRestriction.m_123342_()) / 2, (startRestriction.m_123343_() + endRestriction.m_123343_()) / 2) + BlockPosUtil.dist(startRestriction, endRestriction)), (PathResult)new TreePathResult(), entity);
        this.restrictionBox = new AABB((double)Math.min(startRestriction.m_123341_(), endRestriction.m_123341_()), (double)Math.min(startRestriction.m_123342_(), endRestriction.m_123342_()), (double)Math.min(startRestriction.m_123343_(), endRestriction.m_123343_()), (double)Math.max(startRestriction.m_123341_(), endRestriction.m_123341_()), (double)Math.max(startRestriction.m_123342_(), endRestriction.m_123342_()), (double)Math.max(startRestriction.m_123343_(), endRestriction.m_123343_()));
        this.excludedTrees = excludedTrees;
        this.colony = colony;
        this.dyntreesize = dyntreesize;
        this.searchTowards = BlockPos.m_274446_((Position)this.restrictionBox.m_82399_());
    }

    @Override
    @NotNull
    public TreePathResult getResult() {
        return (TreePathResult)super.getResult();
    }

    @Override
    protected double computeHeuristic(int x, int y, int z) {
        return this.searchTowards == null ? (double)BlockPosUtil.distManhattan(this.start, x, y, z) : (double)BlockPosUtil.distManhattan(this.searchTowards, x, y, z);
    }

    @Override
    protected boolean isAtDestination(@NotNull MNode n) {
        if (this.restrictionBox != null && !this.restrictionBox.m_82393_((double)n.x, (double)n.y, (double)n.z)) {
            return false;
        }
        return n.parent != null && this.isNearTree(n) && SurfaceType.getSurfaceType((BlockGetter)this.world, this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z), (BlockPos)this.tempWorldPos.m_122178_(n.x, n.y - 1, n.z), this.getPathingOptions()) == SurfaceType.WALKABLE;
    }

    private boolean isNearTree(@NotNull MNode n) {
        if (n.parent == null) {
            return false;
        }
        if (n.x == n.parent.x) {
            int dz = n.z > n.parent.z ? 1 : -1;
            return this.isTree((BlockPos)this.tempWorldPos.m_122178_(n.x, n.y, n.z + dz)) || this.isTree((BlockPos)this.tempWorldPos.m_122178_(n.x - 1, n.y, n.z)) || this.isTree((BlockPos)this.tempWorldPos.m_122178_(n.x + 1, n.y, n.z));
        }
        int dx = n.x > n.parent.x ? 1 : -1;
        return this.isTree((BlockPos)this.tempWorldPos.m_122178_(n.x + dx, n.y, n.z)) || this.isTree((BlockPos)this.tempWorldPos.m_122178_(n.x, n.y, n.z - 1)) || this.isTree((BlockPos)this.tempWorldPos.m_122178_(n.x, n.y, n.z + 1));
    }

    private boolean isTree(BlockPos pos) {
        if (Tree.checkTree(this.world, pos, this.excludedTrees, this.dyntreesize) && Tree.checkIfInColony(pos, this.colony, this.world, this.restrictionBox != null)) {
            this.getResult().treeLocation = pos.m_7949_();
            return true;
        }
        return false;
    }

    @Override
    public double getEndNodeScore(MNode n) {
        return BlockPosUtil.distManhattan(this.searchTowards, n.x, n.y, n.z);
    }

    @Override
    protected boolean isPassable(@NotNull BlockState block, int x, int y, int z, MNode parent, boolean head) {
        return super.isPassable(block, x, y, z, parent, head) || this.isLeafLike(block);
    }

    @Override
    protected double modifyCost(double cost, MNode parent, boolean swimstart, boolean swimming, int x, int y, int z, BlockState state, BlockState below) {
        if (!state.m_60795_() && this.isLeafLike(state)) {
            cost *= 3.0;
        } else {
            BlockState above = this.cachedBlockLookup.getBlockState(x, y + 1, z);
            if (!above.m_60795_() && this.isLeafLike(above)) {
                cost *= 3.0;
            }
        }
        if (this.restrictionBox != null && !this.restrictionBox.m_82393_((double)x, (double)y, (double)z)) {
            cost *= 2.0;
        }
        return cost;
    }

    private boolean isLeafLike(@NotNull BlockState block) {
        return block.m_204336_(BlockTags.f_13035_) || Compatibility.isDynamicTrunkShell(block.m_60734_()) || block.m_204336_(ModTags.hugeMushroomBlocks);
    }
}

