/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.citizen.citizenhandlers;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenDiseaseHandler;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.colony.jobs.JobHealer;
import com.minecolonies.core.datalistener.DiseasesListener;
import com.minecolonies.core.datalistener.model.Disease;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public class CitizenDiseaseHandler
implements ICitizenDiseaseHandler {
    public static final double SEEK_DOCTOR_HEALTH = 6.0;
    private static final int DISEASE_FACTOR = 33333;
    private static final int IMMUNITY_TIME = 108000;
    private static final int VACCINE_MODIFIER = 10;
    private final ICitizenData citizenData;
    @Nullable
    private Disease disease;
    private int immunityTicks = 0;
    private boolean sleepsAtHospital = false;
    private static final int initialCitizenCount = (Integer)IMinecoloniesAPI.getInstance().getConfig().getServer().initialCitizenAmount.get();

    public CitizenDiseaseHandler(ICitizenData citizen) {
        this.citizenData = citizen;
    }

    @Override
    public void update(int tickRate) {
        if (this.canBecomeSick()) {
            double citizenModifier = this.citizenData.getDiseaseModifier();
            int configModifier = (Integer)MineColonies.getConfig().getServer().diseaseModifier.get();
            if ((double)this.citizenData.getRandom().nextInt(configModifier * 33333) < citizenModifier * 10.0) {
                this.disease = DiseasesListener.getRandomDisease(this.citizenData.getEntity().map(AbstractEntityCitizen::m_217043_).orElse(RandomSource.m_216327_()));
            }
        }
        if (this.immunityTicks > 0) {
            this.immunityTicks -= tickRate;
        }
    }

    @Override
    public boolean setDisease(@Nullable Disease disease) {
        if (this.canBecomeSick()) {
            this.disease = disease;
            return true;
        }
        return false;
    }

    private boolean canBecomeSick() {
        return !this.isSick() && this.citizenData.getEntity().isPresent() && this.citizenData.getColony().isActive() && !(this.citizenData.getJob() instanceof JobHealer) && this.immunityTicks <= 0 && this.citizenData.getColony().getCitizenManager().getCurrentCitizenCount() > initialCitizenCount;
    }

    @Override
    public void onCollission(ICitizenData citizen) {
        if (citizen.getCitizenDiseaseHandler().isSick() && this.canBecomeSick() && citizen.getRandom().nextInt(100) < 1 && (citizen.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MASKS) <= 0.0 || citizen.getRandom().nextBoolean())) {
            this.disease = citizen.getCitizenDiseaseHandler().getDisease();
        }
    }

    @Override
    public boolean isHurt() {
        return this.citizenData.getEntity().isPresent() && !(this.citizenData.getJob() instanceof AbstractJobGuard) && (double)this.citizenData.getEntity().get().m_21223_() < 6.0 && this.citizenData.getSaturation() > 6.0;
    }

    @Override
    public boolean isSick() {
        return this.disease != null;
    }

    @Override
    public void write(CompoundTag compound) {
        CompoundTag diseaseTag = new CompoundTag();
        if (this.disease != null) {
            diseaseTag.m_128359_("disease_id", this.disease.id().toString());
        }
        diseaseTag.m_128405_("immunity", this.immunityTicks);
        compound.m_128365_("disease", (Tag)diseaseTag);
    }

    @Override
    public void read(CompoundTag compound) {
        if (!compound.m_128425_("disease", 10)) {
            return;
        }
        CompoundTag diseaseTag = compound.m_128469_("disease");
        if (diseaseTag.m_128441_("disease_id")) {
            this.disease = DiseasesListener.getDisease(new ResourceLocation(diseaseTag.m_128461_("disease_id")));
        }
        this.immunityTicks = diseaseTag.m_128451_("immunity");
    }

    @Override
    @Nullable
    public Disease getDisease() {
        return this.disease;
    }

    @Override
    public void cure() {
        this.disease = null;
        this.sleepsAtHospital = false;
        if (this.citizenData.isAsleep() && this.citizenData.getEntity().isPresent()) {
            this.citizenData.getEntity().get().m_5796_();
            BlockPos hospitalPos = this.citizenData.getColony().getBuildingManager().getBestBuilding(this.citizenData.getEntity().get(), BuildingCook.class);
            IColony colony = this.citizenData.getColony();
            IBuilding hospital = colony.getBuildingManager().getBuilding(hospitalPos);
            if (hospital != null) {
                hospital.onWakeUp();
            }
            this.immunityTicks = this.citizenData.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.VACCINES) > 0.0 ? 1080000 : 108000;
        } else {
            this.immunityTicks = 54000;
        }
        this.citizenData.getColony().getStatisticsManager().increment("citizens_healed", this.citizenData.getColony().getDay());
        this.citizenData.markDirty(0);
    }

    @Override
    public boolean sleepsAtHospital() {
        return this.sleepsAtHospital;
    }

    @Override
    public void setSleepsAtHospital(boolean isAtHospital) {
        this.sleepsAtHospital = isAtHospital;
    }
}

