/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.combat;

import com.minecolonies.api.entity.ai.IStateAI;
import com.minecolonies.api.entity.ai.combat.CombatAIStates;
import com.minecolonies.api.entity.ai.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.ai.combat.threat.ThreatTableEntry;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.phys.AABB;

public class TargetAI<T extends Mob>
implements IStateAI {
    protected final T user;
    protected LivingEntity target;

    public TargetAI(T user, int targetFrequency, ITickRateStateMachine stateMachine) {
        this.user = user;
        stateMachine.addTransition(new TickingTransition<CombatAIStates>(CombatAIStates.NO_TARGET, this::checkForTarget, () -> CombatAIStates.ATTACKING, 5));
        stateMachine.addTransition(new TickingTransition<CombatAIStates>(CombatAIStates.NO_TARGET, this::searchNearbyTarget, () -> CombatAIStates.ATTACKING, targetFrequency));
    }

    protected boolean checkForTarget() {
        ThreatTableEntry nextTarget;
        if (this.target != null && !this.target.m_6084_()) {
            this.onTargetDied(this.target);
            this.target = null;
        }
        if ((nextTarget = ((IThreatTableEntity)this.user).getThreatTable().getTarget()) == null) {
            return false;
        }
        if (this.isEntityValidTarget(nextTarget.getEntity())) {
            if (this.target != nextTarget.getEntity()) {
                this.target = nextTarget.getEntity();
                this.onTargetChange();
            }
            return true;
        }
        this.resetTarget();
        return false;
    }

    public boolean isEntityValidTarget(LivingEntity target) {
        if (target == this.user || target == null || !target.m_6084_() || !this.isWithinPersecutionDistance(target)) {
            return false;
        }
        if (target == this.user.m_21188_()) {
            return true;
        }
        return this.isAttackableTarget(target);
    }

    public void resetTarget() {
        if (this.target == null) {
            return;
        }
        if (this.user.m_21214_() == this.target) {
            this.user.m_21335_(null);
        }
        if (this.user.m_21188_() == this.target) {
            this.user.m_6703_(null);
        }
        ((IThreatTableEntity)this.user).getThreatTable().markInvalidTarget();
        this.target = null;
    }

    protected boolean searchNearbyTarget() {
        if (this.checkForTarget()) {
            return true;
        }
        List entities = ((Mob)this.user).f_19853_.m_45976_(LivingEntity.class, this.getSearchArea());
        if (entities.isEmpty()) {
            return false;
        }
        boolean foundTarget = false;
        for (LivingEntity entity : entities) {
            if (!entity.m_6084_()) continue;
            if (this.skipSearch(entity)) {
                return false;
            }
            if (!this.isEntityValidTarget(entity) || !this.user.m_21574_().m_148306_((Entity)entity)) continue;
            ((IThreatTableEntity)this.user).getThreatTable().addThreat(entity, 0);
            foundTarget = true;
        }
        return foundTarget;
    }

    protected boolean skipSearch(LivingEntity entity) {
        return false;
    }

    protected AABB getSearchArea() {
        BlockPos raiderPos = this.user.m_20183_();
        Direction randomDirection = Direction.m_122376_((int)(this.user.m_217043_().m_188503_(4) + 2));
        int searchRange = this.getSearchRange();
        double x1 = raiderPos.m_123341_() + Math.max(searchRange * randomDirection.m_122429_() + 16, 16);
        double x2 = raiderPos.m_123341_() + Math.min(searchRange * randomDirection.m_122429_() - 16, -16);
        double y1 = raiderPos.m_123342_() + this.getYSearchRange();
        double y2 = raiderPos.m_123342_() - this.getYSearchRange();
        double z1 = raiderPos.m_123343_() + Math.max(searchRange * randomDirection.m_122431_() + 16, 16);
        double z2 = raiderPos.m_123343_() + Math.min(searchRange * randomDirection.m_122431_() - 16, -16);
        return new AABB(x1, y1, z1, x2, y2, z2);
    }

    protected int getYSearchRange() {
        return 3;
    }

    protected int getSearchRange() {
        return 16;
    }

    protected boolean isAttackableTarget(LivingEntity target) {
        return target instanceof Enemy && !this.user.getClass().isInstance(target);
    }

    protected boolean isWithinPersecutionDistance(LivingEntity target) {
        return true;
    }

    protected void onTargetDied(LivingEntity target) {
    }

    protected void onTargetChange() {
    }
}

