/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.workorders;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.colony.jobs.JobBuilder;
import com.minecolonies.core.colony.workorders.AbstractWorkOrder;
import com.minecolonies.core.entity.ai.workers.util.ConstructionTapeHelper;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.NotNull;

public class WorkOrderDecoration
extends AbstractWorkOrder {
    public static WorkOrderDecoration create(@NotNull WorkOrderType type, String packName, String path, String translationKey, BlockPos location, int rotation, boolean mirror, int currentLevel) {
        int targetLevel = currentLevel;
        switch (type) {
            case BUILD: {
                targetLevel = 1;
                break;
            }
            case UPGRADE: {
                ++targetLevel;
                break;
            }
            case REMOVE: {
                targetLevel = 0;
            }
        }
        return new WorkOrderDecoration(packName, path, translationKey, type, location, rotation, mirror, currentLevel, targetLevel);
    }

    public WorkOrderDecoration() {
    }

    private WorkOrderDecoration(String packName, String path, String translationKey, WorkOrderType workOrderType, BlockPos location, int rotation, boolean isMirrored, int currentLevel, int targetLevel) {
        super(packName, path, translationKey, workOrderType, location, rotation, isMirrored, currentLevel, targetLevel);
    }

    @Override
    public boolean canBuild(@NotNull ICitizenData citizen) {
        return citizen.getJob() instanceof JobBuilder;
    }

    @Override
    public boolean isValid(IColony colony) {
        return super.isValid(colony) && this.getStructurePath() != null && !this.getStructurePath().isEmpty();
    }

    @Override
    public void onAdded(IColony colony, boolean readingFromNbt) {
        super.onAdded(colony, readingFromNbt);
        if (!readingFromNbt && colony != null && colony.getWorld() != null) {
            ConstructionTapeHelper.placeConstructionTape(this, colony.getWorld(), colony);
            MessageUtils.format("com.minecolonies.coremod.decoorderadded", colony.getName()).sendTo(colony).forManagers();
        }
    }

    @Override
    public void onRemoved(IColony colony) {
        super.onRemoved(colony);
        ConstructionTapeHelper.removeConstructionTape(this, colony.getWorld());
    }
}

