/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestResolverIdentitiesDataStore;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class StandardRequestResolversIdentitiesDataStore
implements IRequestResolverIdentitiesDataStore {
    private IToken<?> id;
    private final BiMap<IToken<?>, IRequestResolver<?>> map;

    public StandardRequestResolversIdentitiesDataStore(IToken<?> id, BiMap<IToken<?>, IRequestResolver<?>> map) {
        this.id = id;
        this.map = map;
    }

    public StandardRequestResolversIdentitiesDataStore() {
        this.id = StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN);
        this.map = HashBiMap.create();
    }

    @Override
    public BiMap<IToken<?>, IRequestResolver<?>> getIdentities() {
        return this.map;
    }

    @Override
    public IToken<?> getId() {
        return this.id;
    }

    @Override
    public void setId(IToken<?> id) {
        this.id = id;
    }

    public static class Factory
    implements IFactory<FactoryVoidInput, StandardRequestResolversIdentitiesDataStore> {
        @Override
        @NotNull
        public TypeToken<? extends StandardRequestResolversIdentitiesDataStore> getFactoryOutputType() {
            return TypeToken.of(StandardRequestResolversIdentitiesDataStore.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public StandardRequestResolversIdentitiesDataStore getNewInstance(@NotNull IFactoryController factoryController, @NotNull FactoryVoidInput factoryVoidInput, Object ... context) throws IllegalArgumentException {
            return new StandardRequestResolversIdentitiesDataStore();
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull StandardRequestResolversIdentitiesDataStore standardRequestIdentitiesDataStore) {
            CompoundTag systemCompound = new CompoundTag();
            systemCompound.m_128365_("Token", (Tag)controller.serialize(standardRequestIdentitiesDataStore.getId()));
            systemCompound.m_128365_("List", (Tag)standardRequestIdentitiesDataStore.getIdentities().keySet().stream().map(token -> {
                CompoundTag mapCompound = new CompoundTag();
                mapCompound.m_128365_("Token", (Tag)controller.serialize(token));
                mapCompound.m_128365_("Resolver", (Tag)controller.serialize((IRequestResolver)standardRequestIdentitiesDataStore.getIdentities().get(token)));
                return mapCompound;
            }).collect(NBTUtils.toListNBT()));
            return systemCompound;
        }

        @Override
        @NotNull
        public StandardRequestResolversIdentitiesDataStore deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            IToken token = (IToken)controller.deserialize(nbt.m_128469_("Token"));
            ListTag list = nbt.m_128437_("List", 10);
            HashBiMap biMap = HashBiMap.create();
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag mapCompound = list.m_128728_(i);
                IToken id = (IToken)controller.deserialize(mapCompound.m_128469_("Token"));
                IRequestResolver resolver = (IRequestResolver)controller.deserialize(mapCompound.m_128469_("Resolver"));
                if (!resolver.isValid()) continue;
                biMap.put((Object)id, (Object)resolver);
            }
            return new StandardRequestResolversIdentitiesDataStore(token, (BiMap<IToken<?>, IRequestResolver<?>>)biMap);
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequestResolversIdentitiesDataStore input, FriendlyByteBuf packetBuffer) {
            controller.serialize(packetBuffer, input.id);
            packetBuffer.writeInt(input.getIdentities().size());
            input.getIdentities().forEach((key, value) -> {
                controller.serialize(packetBuffer, key);
                controller.serialize(packetBuffer, value);
            });
        }

        @Override
        public StandardRequestResolversIdentitiesDataStore deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
            IToken token = (IToken)controller.deserialize(buffer);
            HashMap<IToken, IRequestResolver> identities = new HashMap<IToken, IRequestResolver>();
            int assignmentsSize = buffer.readInt();
            for (int i = 0; i < assignmentsSize; ++i) {
                identities.put((IToken)controller.deserialize(buffer), (IRequestResolver)controller.deserialize(buffer));
            }
            HashBiMap biMap = HashBiMap.create(identities);
            return new StandardRequestResolversIdentitiesDataStore(token, (BiMap<IToken<?>, IRequestResolver<?>>)biMap);
        }

        @Override
        public short getSerializationId() {
            return 33;
        }
    }
}

