/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.managers;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.IResearchManager;
import com.minecolonies.api.research.ResearchBranchType;
import com.minecolonies.api.research.effects.IResearchEffect;
import com.minecolonies.api.research.effects.IResearchEffectManager;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.Network;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.network.messages.client.colony.ColonyViewResearchManagerViewMessage;
import com.minecolonies.core.research.LocalResearch;
import com.minecolonies.core.research.LocalResearchTree;
import com.minecolonies.core.research.ResearchEffectManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ResearchManager
implements IResearchManager {
    private final LocalResearchTree tree;
    private final IResearchEffectManager effects = new ResearchEffectManager();
    private final List<IGlobalResearch> autoStartResearch = new ArrayList<IGlobalResearch>();
    private final IColony colony;
    private boolean dirty;

    @Override
    public void readFromNBT(@NotNull CompoundTag compound) {
        this.tree.readFromNBT(compound, this.effects);
    }

    @Override
    public void writeToNBT(@NotNull CompoundTag compound) {
        this.tree.writeToNBT(compound);
    }

    @Override
    public void sendPackets(Set<ServerPlayer> closeSubscribers, Set<ServerPlayer> newSubscribers) {
        if (this.dirty || !newSubscribers.isEmpty()) {
            HashSet<ServerPlayer> players = new HashSet<ServerPlayer>();
            if (this.dirty) {
                players.addAll(closeSubscribers);
            }
            players.addAll(newSubscribers);
            ColonyViewResearchManagerViewMessage message = new ColonyViewResearchManagerViewMessage(this.colony, this);
            players.forEach(player -> Network.getNetwork().sendToPlayer(message, (ServerPlayer)player));
        }
        this.clearDirty();
    }

    @Override
    public final void markDirty() {
        this.dirty = true;
    }

    @Override
    public final boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void clearDirty() {
        this.dirty = false;
    }

    public ResearchManager(IColony colony) {
        this.colony = colony;
        this.autoStartResearch.addAll(MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().getAutostartResearches());
        this.tree = new LocalResearchTree(colony);
    }

    @Override
    public LocalResearchTree getResearchTree() {
        return this.tree;
    }

    @Override
    public IResearchEffectManager getResearchEffects() {
        return this.effects;
    }

    @Override
    public ResourceLocation getResearchEffectIdFrom(Block block) {
        return new ResourceLocation(ForgeRegistries.BLOCKS.getKey((Object)block).m_135827_(), "effects/" + ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_());
    }

    @Override
    public void checkAutoStartResearch() {
        if (this.colony == null || !(this.colony instanceof Colony)) {
            return;
        }
        ArrayList<IGlobalResearch> removes = new ArrayList<IGlobalResearch>();
        for (IGlobalResearch research : this.autoStartResearch) {
            if (!IGlobalResearchTree.getInstance().isResearchRequirementsFulfilled(research.getResearchRequirement(), this.colony)) continue;
            if (IGlobalResearchTree.getInstance().getBranchData(research.getBranch()).getType() != ResearchBranchType.UNLOCKABLES) {
                int level = 0;
                Map<BlockPos, IBuilding> buildings = this.colony.getBuildingManager().getBuildings();
                for (Map.Entry<BlockPos, IBuilding> building : buildings.entrySet()) {
                    if (building.getValue().getBuildingType() != ModBuildings.university.get() || building.getValue().getBuildingLevel() <= level) continue;
                    level = building.getValue().getBuildingLevel();
                }
                if (level < research.getDepth()) continue;
            }
            boolean researchAlreadyRun = false;
            for (ILocalResearch progressResearch : this.colony.getResearchManager().getResearchTree().getResearchInProgress()) {
                if (!progressResearch.getId().equals((Object)research.getId())) continue;
                researchAlreadyRun = true;
                break;
            }
            if (researchAlreadyRun || this.colony.getResearchManager().getResearchTree().hasCompletedResearch(research.getId())) {
                removes.add(research);
                continue;
            }
            if (!research.getCostList().isEmpty()) {
                MessageUtils.format("com.minecolonies.coremod.research.available", MutableComponent.m_237204_((ComponentContents)research.getName())).sendTo(this.colony).forAllPlayers();
                for (Player player : this.colony.getMessagePlayerEntities()) {
                    SoundUtils.playSuccessSound(player, player.m_20183_());
                }
            } else {
                this.startCostlessResearch(research);
            }
            removes.add(research);
        }
        this.autoStartResearch.removeAll(removes);
        this.markDirty();
    }

    private void startCostlessResearch(IGlobalResearch research) {
        this.markDirty();
        boolean creativePlayer = false;
        for (Player player : this.colony.getMessagePlayerEntities()) {
            if (!player.m_7500_()) continue;
            creativePlayer = true;
        }
        this.tree.addResearch(research.getBranch(), new LocalResearch(research.getId(), research.getBranch(), research.getDepth()));
        if (research.isInstant() || creativePlayer && ((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().researchCreativeCompletion.get()).booleanValue()) {
            ILocalResearch localResearch = this.tree.getResearch(research.getBranch(), research.getId());
            localResearch.setProgress(IGlobalResearchTree.getInstance().getBranchData(research.getBranch()).getBaseTime(research.getDepth()));
            localResearch.setState(ResearchState.FINISHED);
            this.tree.finishResearch(research.getId());
            for (IResearchEffect<?> iResearchEffect : IGlobalResearchTree.getInstance().getResearch(research.getBranch(), research.getId()).getEffects()) {
                this.effects.applyEffect(iResearchEffect);
            }
            for (ICitizenData iCitizenData : this.colony.getCitizenManager().getCitizens()) {
                iCitizenData.applyResearchEffects();
            }
            MessageUtils.format("com.minecolonies.coremod.university.researchconcluded." + ThreadLocalRandom.current().nextInt(3), MutableComponent.m_237204_((ComponentContents)IGlobalResearchTree.getInstance().getResearch(research.getBranch(), research.getId()).getName())).sendTo(this.colony).forAllPlayers();
            for (Player player : this.colony.getMessagePlayerEntities()) {
                SoundUtils.playSuccessSound(player, player.m_20183_());
            }
        } else {
            MessageUtils.format("com.minecolonies.coremod.research.available", MutableComponent.m_237204_((ComponentContents)research.getName())).append("com.minecolonies.coremod.research.started", MutableComponent.m_237204_((ComponentContents)research.getName())).sendTo(this.colony).forAllPlayers();
            for (Player player : this.colony.getMessagePlayerEntities()) {
                SoundUtils.playSuccessSound(player, player.m_20183_());
            }
        }
    }
}

