/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.core.colony.buildings.modules.MinimumStockModule;
import com.minecolonies.core.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.core.colony.buildings.modules.settings.SettingKey;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class BuildingNetherWorker
extends AbstractBuilding {
    public static final ISettingKey<BoolSetting> CLOSE_PORTAL = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "closeportal"));
    private static final String NETHER_WORKER = "netherworker";
    private static final String TAG_CURRENT_TRIPS = "current_trips";
    private static final String TAG_CURRENT_DAY = "current_day";
    private static final int MAX_PER_PERIOD = 1;
    private static final int PERIOD_DAYS = 3;
    public static final String FOOD_EXCLUSION_LIST = "food";
    private int currentPeriodDay = 0;
    private int currentTrips = 0;
    private long snapTime;

    public BuildingNetherWorker(@NotNull IColony colony, BlockPos pos) {
        super(colony, pos);
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.axe.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.pickaxe.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.shovel.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.sword.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> itemStack.m_41720_() instanceof FlintAndSteelItem, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> !ItemStackUtils.isEmpty(itemStack) && itemStack.m_41720_() instanceof ArmorItem && ((ArmorItem)itemStack.m_41720_()).m_40402_() == EquipmentSlot.HEAD, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> !ItemStackUtils.isEmpty(itemStack) && itemStack.m_41720_() instanceof ArmorItem && ((ArmorItem)itemStack.m_41720_()).m_40402_() == EquipmentSlot.CHEST, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> !ItemStackUtils.isEmpty(itemStack) && itemStack.m_41720_() instanceof ArmorItem && ((ArmorItem)itemStack.m_41720_()).m_40402_() == EquipmentSlot.LEGS, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> !ItemStackUtils.isEmpty(itemStack) && itemStack.m_41720_() instanceof ArmorItem && ((ArmorItem)itemStack.m_41720_()).m_40402_() == EquipmentSlot.FEET, new Tuple((Object)1, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return NETHER_WORKER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public boolean shallClosePortalOnReturn() {
        return this.getSetting(CLOSE_PORTAL).getValue();
    }

    @Override
    public void onWakeUp() {
        super.onWakeUp();
        this.snapTime = this.colony.getWorld().m_46468_();
        if (this.currentPeriodDay < BuildingNetherWorker.getPeriodDays()) {
            ++this.currentPeriodDay;
        } else {
            this.currentPeriodDay = 0;
            this.currentTrips = 0;
        }
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        if (compound.m_128441_(TAG_CURRENT_TRIPS)) {
            this.currentTrips = compound.m_128451_(TAG_CURRENT_TRIPS);
        }
        if (compound.m_128441_(TAG_CURRENT_DAY)) {
            this.currentPeriodDay = compound.m_128451_(TAG_CURRENT_DAY);
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128405_(TAG_CURRENT_TRIPS, this.currentTrips);
        compound.m_128405_(TAG_CURRENT_DAY, this.currentPeriodDay);
        return compound;
    }

    @Override
    public int buildingRequiresCertainAmountOfItem(ItemStack stack, List<ItemStorage> localAlreadyKept, boolean inventory, JobEntry jobEntry) {
        if (stack.m_41619_()) {
            return 0;
        }
        if (inventory && ((MinimumStockModule)this.getFirstModuleOccurance(MinimumStockModule.class)).isStocked(stack)) {
            return stack.m_41613_();
        }
        IRecipeStorage rs = ((CraftingModule)this.getFirstModuleOccurance(CraftingModule.class)).getFirstRecipe(ItemStack::m_41619_);
        if (rs != null) {
            ItemStorage kept = new ItemStorage(stack);
            boolean containsItem = rs.getInput().contains(kept);
            int keptCount = localAlreadyKept.stream().filter(storage -> storage.equals(kept)).mapToInt(ItemStorage::getAmount).sum();
            if (containsItem && (keptCount < 64 || !inventory)) {
                if (localAlreadyKept.contains(kept)) {
                    kept.setAmount(localAlreadyKept.remove(localAlreadyKept.indexOf(kept)).getAmount());
                }
                localAlreadyKept.add(kept);
                return 0;
            }
        }
        return super.buildingRequiresCertainAmountOfItem(stack, localAlreadyKept, inventory, jobEntry);
    }

    public boolean isReadyForTrip() {
        if (this.snapTime == 0L) {
            this.snapTime = this.colony.getWorld().m_46468_();
        }
        if (Math.abs(this.colony.getWorld().m_46468_() - this.snapTime) >= 24000L) {
            ++this.currentPeriodDay;
        }
        return this.currentTrips < BuildingNetherWorker.getMaxPerPeriod();
    }

    public void recordTrip() {
        ++this.currentTrips;
    }

    public BlockPos getPortalLocation() {
        BlockPos portalLocation = this.getFirstLocationFromTag("portal");
        if (portalLocation != null) {
            return portalLocation.m_7494_();
        }
        return null;
    }

    public BlockPos getVaultLocation() {
        return this.getFirstLocationFromTag("vault");
    }

    public static int getMaxPerPeriod() {
        return 1;
    }

    public static int getPeriodDays() {
        return 3;
    }

    @Override
    public void onPlacement() {
        super.onPlacement();
        Level world = this.colony.getWorld();
        if (WorldUtil.isNetherType(world)) {
            Block block = world.m_8055_(this.getPosition()).m_60734_();
            block.m_6786_((LevelAccessor)world, this.getPosition(), world.m_8055_(this.getPosition()));
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Custom {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }
    }
}

