/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules.settings;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.buildings.modules.settings.IStringSetting;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StringSetting
implements IStringSetting<String> {
    public static final int MAX_BUTTON_WIDTH = 145;
    private final List<String> settings;
    protected int currentIndex;

    public StringSetting(String ... settings) {
        this.settings = new ArrayList<String>(Arrays.asList(settings));
        this.currentIndex = 0;
    }

    public StringSetting(List<String> settings, int currentIndex) {
        this.settings = new ArrayList<String>(settings);
        this.currentIndex = currentIndex;
    }

    @Override
    public String getValue() {
        return this.settings.get(this.currentIndex);
    }

    @Override
    public String getDefault() {
        return this.settings.get(0);
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public List<String> getSettings() {
        return new ArrayList<String>(this.settings);
    }

    @Override
    public ResourceLocation getLayoutItem() {
        return new ResourceLocation("minecolonies:gui/layouthuts/layoutstringsetting.xml");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setupHandler(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setHandler(button -> settingsModuleView.trigger(key));
    }

    @Override
    public void render(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        int buttonWidth = MathUtils.clamp(this.getButtonWidth(settingsModuleView), 0, 145);
        ButtonImage triggerButton = (ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class);
        triggerButton.setSize(buttonWidth, triggerButton.getHeight());
        triggerButton.setEnabled(this.isActive(settingsModuleView));
        triggerButton.setText(this.getDisplayText());
        this.setHoverPane(key, (Pane)triggerButton, settingsModuleView);
    }

    protected Component getDisplayText() {
        return Component.m_237115_((String)this.settings.get(this.currentIndex));
    }

    @Override
    public void trigger() {
        boolean hasAllowedValue = false;
        for (int i = 0; i < this.settings.size(); ++i) {
            ++this.currentIndex;
            if (this.currentIndex >= this.settings.size()) {
                this.currentIndex = 0;
            }
            if (!this.isIndexAllowed(this.currentIndex)) continue;
            hasAllowedValue = true;
            break;
        }
        if (!hasAllowedValue) {
            Log.getLogger().warn(this.getClass().getName() + " could not select any allowed value, currentIndex is reset to 0, please report this to the developers.");
            this.currentIndex = 0;
        }
    }

    public boolean isIndexAllowed(int index) {
        return index >= 0 && index < this.settings.size();
    }

    @Override
    public void updateSetting(ISetting<?> setting) {
        if (setting instanceof StringSetting) {
            StringSetting stringSetting = (StringSetting)setting;
            this.settings.clear();
            this.settings.addAll(stringSetting.settings);
            if (this.currentIndex >= this.settings.size()) {
                this.currentIndex = this.settings.size() - 1;
            }
        }
    }

    @Override
    public void copyValue(ISetting<?> setting) {
        if (setting instanceof StringSetting) {
            StringSetting other = (StringSetting)setting;
            this.set(other.getValue());
        }
    }

    @Override
    public void set(String value) {
        this.currentIndex = this.getSettings().indexOf(value);
    }

    protected int getButtonWidth(ISettingsModuleView settingsModuleView) {
        return 145;
    }
}

