/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ISettingsModule;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.buildings.modules.settings.SettingKey;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class SettingsModule
extends AbstractBuildingModule
implements IPersistentModule,
ISettingsModule {
    final Map<ISettingKey<?>, ISetting<?>> settings = new LinkedHashMap();

    @Override
    public <T extends ISetting<?>> T getSetting(ISettingKey<T> key) {
        return (T)this.settings.get(key);
    }

    @Override
    @NotNull
    public <T extends ISetting<?>> Optional<T> getOptionalSetting(ISettingKey<T> key) {
        T setting = this.getSetting(key);
        return setting == null || !setting.isActive(this) ? Optional.empty() : Optional.of(setting);
    }

    @Override
    public ISettingsModule with(ISettingKey<?> key, ISetting<?> setting) {
        this.settings.put(key, setting);
        return this;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        CompoundTag settingsCompound = compound.m_128441_("settings") ? compound.m_128469_("settings") : compound;
        ListTag list = settingsCompound.m_128437_("settingslist", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entryCompound = list.m_128728_(i);
            ResourceLocation key = new ResourceLocation(entryCompound.m_128461_("key"));
            try {
                ISetting setting = (ISetting)StandardFactoryController.getInstance().deserialize(entryCompound.m_128469_("value"));
                SettingKey settingsKey = new SettingKey(setting.getClass(), key);
                if (!this.settings.containsKey(settingsKey)) continue;
                setting.updateSetting(this.settings.get(settingsKey));
                this.settings.put(settingsKey, setting);
                continue;
            }
            catch (IllegalArgumentException ex) {
                Log.getLogger().warn("Detected Removed Setting");
            }
        }
    }

    @Override
    public void serializeNBT(CompoundTag compound) {
        ListTag list = new ListTag();
        for (Map.Entry<ISettingKey<?>, ISetting<?>> setting : this.settings.entrySet()) {
            CompoundTag entryCompound = new CompoundTag();
            entryCompound.m_128359_("key", setting.getKey().getUniqueId().toString());
            entryCompound.m_128365_("value", (Tag)StandardFactoryController.getInstance().serialize(setting.getValue()));
            list.add((Object)entryCompound);
        }
        compound.m_128365_("settingslist", (Tag)list);
    }

    @Override
    public void serializeToView(FriendlyByteBuf buf) {
        buf.writeInt(this.settings.size());
        for (Map.Entry<ISettingKey<?>, ISetting<?>> setting : this.settings.entrySet()) {
            buf.m_130085_(setting.getKey().getUniqueId());
            StandardFactoryController.getInstance().serialize(buf, setting.getValue());
        }
    }

    @Override
    public void updateSetting(ISettingKey<?> settingKey, ISetting<?> value, ServerPlayer sender) {
        if (this.settings.containsKey(settingKey)) {
            this.settings.put(settingKey, value);
            value.onUpdate(this.building, sender);
        }
    }

    @Override
    public <S, T extends ISetting<S>> S getSettingValueOrDefault(ISettingKey<T> key, S def) {
        T setting = this.getSetting(key);
        return setting == null ? def : setting.getValue();
    }
}

