/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.managers.interfaces.IStatisticsManager;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.moduleviews.BuildingStatisticsModuleView;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class WindowStatsModule
extends AbstractModuleWindow {
    private static final LinkedHashMap<String, Integer> INTERVAL = new LinkedHashMap();
    private DropDownList intervalDropdown;
    public String selectedInterval = "com.minecolonies.coremod.gui.interval.yesterday";
    private static final String HUT_RESOURCE_SUFFIX = ":gui/layouthuts/layoutstatsmodule.xml";

    public WindowStatsModule(IBuildingView building, BuildingStatisticsModuleView moduleView) {
        super(building, "minecolonies:gui/layouthuts/layoutstatsmodule.xml");
    }

    public void onOpened() {
        super.onOpened();
        this.updateStats();
    }

    private void updateStats() {
        final IStatisticsManager statisticsManager = this.buildingView.getModuleView(BuildingModules.STATS_MODULE).getBuildingStatisticsManager();
        final @NotNull ArrayList<String> stats = new ArrayList<String>(statisticsManager.getStatTypes());
        ((ScrollingList)this.findPaneOfTypeByID("stats", ScrollingList.class)).setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return stats.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                int stat = statisticsManager.getStatTotal((String)stats.get(index));
                int interval = INTERVAL.get(WindowStatsModule.this.selectedInterval);
                if (interval > 0) {
                    stat = statisticsManager.getStatsInPeriod((String)stats.get(index), WindowStatsModule.this.buildingView.getColony().getDay() - interval, WindowStatsModule.this.buildingView.getColony().getDay());
                }
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("desc", Text.class);
                String id = (String)stats.get(index);
                if (id.contains(";")) {
                    String[] split = id.split(";");
                    if (id.contains("'")) {
                        String[] split2 = split[1].split("'");
                        resourceLabel.setText(Component.m_237110_((String)("com.minecolonies.coremod.gui.townhall.stats." + split[0]), (Object[])new Object[]{stat, Component.m_237115_((String)split2[1])}));
                    } else {
                        resourceLabel.setText(Component.m_237110_((String)("com.minecolonies.coremod.gui.townhall.stats." + split[0]), (Object[])new Object[]{stat, Component.m_237115_((String)split[1])}));
                    }
                } else {
                    resourceLabel.setText(Component.m_237110_((String)("com.minecolonies.coremod.gui.townhall.stats." + id), (Object[])new Object[]{stat}));
                }
            }
        });
        this.intervalDropdown = (DropDownList)this.findPaneOfTypeByID("intervals", DropDownList.class);
        this.intervalDropdown.setHandler(this::onDropDownListChanged);
        this.intervalDropdown.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return INTERVAL.size();
            }

            public String getLabel(int index) {
                return Component.m_237115_((String)((String)INTERVAL.keySet().toArray()[index])).getString();
            }
        });
        this.intervalDropdown.setSelectedIndex(new ArrayList<String>(INTERVAL.keySet()).indexOf(this.selectedInterval));
    }

    private void onDropDownListChanged(DropDownList dropDownList) {
        String temp = (String)INTERVAL.keySet().toArray()[dropDownList.getSelectedIndex()];
        if (!temp.equals(this.selectedInterval)) {
            this.selectedInterval = temp;
            this.updateStats();
        }
    }

    static {
        INTERVAL.put("com.minecolonies.coremod.gui.interval.yesterday", 1);
        INTERVAL.put("com.minecolonies.coremod.gui.interval.lastweek", 7);
        INTERVAL.put("com.minecolonies.coremod.gui.interval.100days", 100);
        INTERVAL.put("com.minecolonies.coremod.gui.interval.alltime", -1);
    }
}

