/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractWindowRequestTree;
import com.minecolonies.core.network.messages.server.colony.UpdateRequestStateMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.NotNull;

public class WindowClipBoard
extends AbstractWindowRequestTree {
    private static final String BUILD_TOOL_RESOURCE_SUFFIX = ":gui/windowclipboard.xml";
    private final List<IToken<?>> asyncRequest = new ArrayList();
    private final IColonyView colony;
    private boolean hide = false;

    public WindowClipBoard(IColonyView colony) {
        super(null, "minecolonies:gui/windowclipboard.xml", colony);
        this.colony = colony;
        for (ICitizenDataView view : this.colony.getCitizens().values()) {
            if (view.getJobView() == null) continue;
            this.asyncRequest.addAll(view.getJobView().getAsyncRequests());
        }
        this.registerButton("important", this::toggleImportant);
    }

    private void toggleImportant() {
        this.hide = !this.hide;
    }

    @Override
    public ImmutableList<IRequest<?>> getOpenRequestsFromBuilding(IBuildingView building) {
        ArrayList requests = Lists.newArrayList();
        if (this.colony == null) {
            return ImmutableList.of();
        }
        IRequestManager requestManager = this.colony.getRequestManager();
        if (requestManager == null) {
            return ImmutableList.of();
        }
        try {
            IPlayerRequestResolver resolver = requestManager.getPlayerResolver();
            IRetryingRequestResolver retryingRequestResolver = requestManager.getRetryingRequestResolver();
            HashSet requestTokens = new HashSet();
            requestTokens.addAll((Collection<IToken<?>>)resolver.getAllAssignedRequests());
            requestTokens.addAll((Collection<IToken<?>>)retryingRequestResolver.getAllAssignedRequests());
            for (IToken iToken : requestTokens) {
                IRequest<?> request2 = requestManager.getRequestForToken(iToken);
                while (request2 != null && request2.hasParent()) {
                    request2 = requestManager.getRequestForToken((IToken<?>)request2.getParent());
                }
                if (request2 == null || requests.contains(request2)) continue;
                requests.add(request2);
            }
            if (this.hide) {
                requests.removeIf(req -> this.asyncRequest.contains(req.getId()));
            }
            BlockPos playerPos = Minecraft.m_91087_().f_91074_.m_20183_();
            requests.sort(Comparator.comparing(request -> request.getRequester().getLocation().getInDimensionLocation().m_123331_(new Vec3i(playerPos.m_123341_(), playerPos.m_123342_(), playerPos.m_123343_()))).thenComparingInt(request -> request.getId().hashCode()));
        }
        catch (Exception e) {
            Log.getLogger().warn("Exception trying to retreive requests:", (Throwable)e);
            requestManager.reset();
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)requests);
    }

    @Override
    public boolean fulfillable(IRequest<?> tRequest) {
        return false;
    }

    @Override
    protected void cancel(@NotNull IRequest<?> request) {
        Network.getNetwork().sendToServer(new UpdateRequestStateMessage(this.colony, (IToken<?>)request.getId(), RequestState.CANCELLED, null));
    }
}

