/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.utils;

import com.ldtteam.storageracks.ItemStorage;
import com.ldtteam.storageracks.inv.CombinedItemHandler;
import com.ldtteam.storageracks.utils.ItemStackUtils;
import com.ldtteam.storageracks.utils.Log;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;

public final class SortingUtils {
    private SortingUtils() {
    }

    public static void sort(CombinedItemHandler inv) {
        if (inv != null) {
            CompoundTag backup = inv.serializeNBT();
            AtomicInteger runCount = new AtomicInteger(0);
            try {
                HashMap<ItemStorage, Integer> map = new HashMap<ItemStorage, Integer>();
                for (int i = 0; i < inv.getSlots(); ++i) {
                    if (ItemStackUtils.isEmpty(inv.getStackInSlot(i)).booleanValue()) continue;
                    ItemStorage storage = new ItemStorage(inv.extractItem(i, 64, false));
                    int amount = storage.getAmount();
                    if (map.containsKey(storage)) {
                        amount += ((Integer)map.remove(storage)).intValue();
                    }
                    map.put(storage, amount);
                }
                AtomicInteger sum = SortingUtils.calcRequiredSlots(map);
                double totalSlots = inv.getSlots();
                int totalReq = sum.get();
                List sortedList = map.entrySet().stream().sorted(SortingUtils::compare).toList();
                for (int index = 0; index < sortedList.size(); ++index) {
                    SortingUtils.pushIntoInv(runCount, (Map.Entry)sortedList.get(index), inv, sum, totalSlots, totalReq, index + 1 < sortedList.size() ? (ItemStorage)((Map.Entry)sortedList.get(index + 1)).getKey() : null);
                }
            }
            catch (Exception e) {
                inv.deserializeNBT(backup);
                Log.getLogger().warn("Storage sorting had an error, report it to the mod author.", (Throwable)e);
            }
        }
    }

    private static void pushIntoInv(AtomicInteger currentSlot, Map.Entry<ItemStorage, Integer> entry, CombinedItemHandler inv, AtomicInteger requiredSlots, double totalSlots, double totalRequirement, ItemStorage next) {
        ItemStack tempStack;
        int slotLimit = 0;
        ItemStack stack = entry.getKey().getItemStack();
        for (int tempSize = entry.getValue().intValue(); tempSize > 0; tempSize -= tempStack.m_41613_()) {
            tempStack = stack.m_41777_();
            tempStack.m_41764_(Math.min(tempSize, tempStack.m_41741_()));
            slotLimit = inv.getLastIndex(currentSlot.get());
            while (!inv.insertItem(currentSlot.getAndIncrement(), tempStack, false).m_41619_()) {
                Log.getLogger().error("Trying to dump into same slot again!", (Throwable)new Exception());
            }
            requiredSlots.decrementAndGet();
        }
        if (next != null && Math.abs(SortingUtils.getId(next.getItem()) - SortingUtils.getId(entry.getKey().getItem())) > 18 && totalSlots - (double)slotLimit >= (double)requiredSlots.get()) {
            double dumpedSlots = totalRequirement - (double)requiredSlots.get();
            double usageFactor = totalSlots / dumpedSlots;
            double theoreticalJumpFactor = (totalSlots - (double)slotLimit) / (double)requiredSlots.get();
            if (theoreticalJumpFactor <= usageFactor || theoreticalJumpFactor > 4.0) {
                currentSlot.set(slotLimit);
            }
        }
    }

    private static int compare(Map.Entry<ItemStorage, Integer> t1, Map.Entry<ItemStorage, Integer> t2) {
        int id2;
        int id1 = SortingUtils.getId(t1.getKey().getItem());
        if (id1 == (id2 = SortingUtils.getId(t2.getKey().getItem()))) {
            return 0;
        }
        return id1 - id2;
    }

    private static int getId(Item item) {
        return ((ForgeRegistry)ForgeRegistries.ITEMS).getID((Object)item);
    }

    private static AtomicInteger calcRequiredSlots(Map<ItemStorage, Integer> map) {
        int sum = 0;
        for (Map.Entry<ItemStorage, Integer> entry : map.entrySet()) {
            sum = (int)((double)sum + Math.ceil((double)entry.getValue().intValue() / (double)entry.getKey().getItemStack().m_41741_()));
        }
        return new AtomicInteger(sum);
    }
}

