/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.utils;

import com.ldtteam.storageracks.utils.ItemStackUtils;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryUtils {
    private static final double SPAWN_MODIFIER = 0.8;
    private static final double SPAWN_ADDITION = 0.1;
    private static final int MAX_RANDOM_SPAWN = 21;
    private static final int MIN_RANDOM_SPAWN = 10;
    private static final double MOTION_MULTIPLIER = (double)0.05f;
    private static final double MOTION_Y_MIN = (double)0.2f;

    private InventoryUtils() {
    }

    private static boolean compareItems(@Nullable ItemStack itemStack, Item targetItem) {
        return ItemStackUtils.isEmpty(itemStack) == false && itemStack.m_41720_() == targetItem;
    }

    public static int findFirstSlotInItemHandlerWith(@NotNull IItemHandler itemHandler, @NotNull Item targetItem) {
        return InventoryUtils.findFirstSlotInItemHandlerWith(itemHandler, (ItemStack stack) -> InventoryUtils.compareItems(stack, targetItem));
    }

    public static int findFirstSlotInItemHandlerWith(@NotNull IItemHandler itemHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            if (!itemStackSelectionPredicate.test(itemHandler.getStackInSlot(slot))) continue;
            return slot;
        }
        return -1;
    }

    @NotNull
    public static Set<IItemHandler> getItemHandlersFromProvider(@NotNull ICapabilityProvider provider) {
        HashSet<IItemHandler> handlerList = new HashSet<IItemHandler>();
        for (Direction side : Direction.values()) {
            provider.getCapability(ForgeCapabilities.ITEM_HANDLER, side).ifPresent(handlerList::add);
        }
        provider.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(handlerList::add);
        return handlerList;
    }

    public static boolean transferItemStackIntoNextBestSlotInItemHandler(ItemStack stack, @NotNull IItemHandler targetHandler) {
        return InventoryUtils.transferItemStackIntoNextBestSlotInItemHandlerWithResult(stack, targetHandler).m_41619_();
    }

    public static ItemStack transferItemStackIntoNextBestSlotInItemHandlerWithResult(ItemStack stack, @NotNull IItemHandler targetHandler) {
        ItemStack sourceStack = stack.m_41777_();
        if (ItemStackUtils.isEmpty(sourceStack).booleanValue()) {
            return sourceStack;
        }
        if (ItemStackUtils.isEmpty(sourceStack = InventoryUtils.mergeItemStackIntoNextBestSlotInItemHandlers(sourceStack, targetHandler)).booleanValue()) {
            return sourceStack;
        }
        for (int i = 0; i < targetHandler.getSlots(); ++i) {
            if (!ItemStackUtils.isEmpty(sourceStack = targetHandler.insertItem(i, sourceStack, false)).booleanValue()) continue;
            return sourceStack;
        }
        return sourceStack;
    }

    public static ItemStack mergeItemStackIntoNextBestSlotInItemHandlers(ItemStack stack, @NotNull IItemHandler targetHandler) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return stack;
        }
        ItemStack sourceStack = stack.m_41777_();
        for (int i = 0; i < targetHandler.getSlots(); ++i) {
            if (ItemStackUtils.isEmpty(targetHandler.getStackInSlot(i)).booleanValue() || !ItemStack.m_41656_((ItemStack)targetHandler.getStackInSlot(i), (ItemStack)sourceStack) || !ItemStackUtils.isEmpty(sourceStack = targetHandler.insertItem(i, sourceStack, false)).booleanValue()) continue;
            return sourceStack;
        }
        return sourceStack;
    }

    public static void dropItemHandler(IItemHandler handler, Level world, int x, int y, int z) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack itemstack = handler.getStackInSlot(i);
            if (ItemStackUtils.isEmpty(itemstack).booleanValue()) continue;
            InventoryUtils.spawnItemStack(world, x, y, z, itemstack);
        }
    }

    public static void spawnItemStack(Level world, double x, double y, double z, ItemStack stack) {
        Random random = new Random();
        double spawnX = random.nextDouble() * 0.8 + 0.1;
        double spawnY = random.nextDouble() * 0.8 + 0.1;
        double spawnZ = random.nextDouble() * 0.8 + 0.1;
        while (stack.m_41613_() > 0) {
            int randomSplitStackSize = random.nextInt(21) + 10;
            ItemEntity ItemEntity2 = new ItemEntity(world, x + spawnX, y + spawnY, z + spawnZ, stack.m_41620_(randomSplitStackSize));
            ItemEntity2.m_20334_(random.nextGaussian() * (double)0.05f, random.nextGaussian() * (double)0.05f + (double)0.2f, random.nextGaussian() * (double)0.05f);
            world.m_7967_((Entity)ItemEntity2);
        }
    }
}

