/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.tileentities;

import com.ldtteam.storageracks.blocks.ControllerBlock;
import com.ldtteam.storageracks.inv.InsertContainer;
import com.ldtteam.storageracks.tileentities.AbstractTileEntityRack;
import com.ldtteam.storageracks.tileentities.ModTileEntities;
import com.ldtteam.storageracks.tileentities.TileEntityRack;
import com.ldtteam.storageracks.utils.BlockPosUtil;
import com.ldtteam.storageracks.utils.InventoryUtils;
import com.ldtteam.storageracks.utils.WorldUtil;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityController
extends BlockEntity
implements MenuProvider {
    public Set<BlockPos> racks = new HashSet<BlockPos>();
    private int tier;
    private boolean unlockedSort;
    private boolean unlockedInsert;

    public TileEntityRack getRackForStack(ItemStack stack) {
        TileEntityRack rack = this.getPositionOfChestWithItemStack(stack);
        if (rack == null && (rack = this.getPositionOfChestWithSimilarItemStack(stack)) == null) {
            rack = this.searchMostEmptyRack();
        }
        return rack;
    }

    public boolean insertItemStack(ItemStack stack) {
        TileEntityRack rack = this.getRackForStack(stack);
        if (rack == null) {
            return false;
        }
        return InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(stack, (IItemHandler)rack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse((Object)new ItemStackHandler(0)));
    }

    public TileEntityController(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.CONTROLLER.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.racks.clear();
        this.setTier(((ControllerBlock)this.m_58900_().m_60734_()).getTier());
        ListTag racksNBT = compound.m_128437_("inventory", 10);
        for (int i = 0; i < racksNBT.size(); ++i) {
            CompoundTag posCompound = racksNBT.m_128728_(i);
            this.racks.add(BlockPosUtil.readFromNBT(posCompound, "pos"));
        }
        this.unlockedSort = compound.m_128471_("sort");
        this.unlockedInsert = compound.m_128471_("insert");
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        @NotNull ListTag racksNBT = new ListTag();
        for (BlockPos pos : this.racks) {
            CompoundTag newCompound = new CompoundTag();
            BlockPosUtil.writeToNBT(newCompound, "pos", pos);
            racksNBT.add((Object)newCompound);
        }
        compound.m_128365_("inventory", (Tag)racksNBT);
        compound.m_128379_("sort", this.unlockedSort);
        compound.m_128379_("insert", this.unlockedInsert);
    }

    public void m_6596_() {
        WorldUtil.markChunkDirty(this.f_58857_, this.m_58899_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public void unlockSort() {
        this.unlockedSort = true;
        this.m_6596_();
    }

    public void unlockInsert() {
        this.unlockedInsert = true;
        this.m_6596_();
    }

    public boolean isSortUnlocked() {
        return this.unlockedSort;
    }

    public boolean isInsertUnlocked() {
        return this.unlockedInsert;
    }

    @Nullable
    public TileEntityRack getPositionOfChestWithItemStack(@NotNull ItemStack stack) {
        for (BlockPos pos : this.racks) {
            BlockEntity entity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)this.f_58857_, pos) || !((entity = this.m_58904_().m_7702_(pos)) instanceof AbstractTileEntityRack) || ((AbstractTileEntityRack)entity).getFreeSlots() <= 0 || !((AbstractTileEntityRack)entity).hasItemStack(stack, 1)) continue;
            return (TileEntityRack)entity;
        }
        return null;
    }

    @Nullable
    public TileEntityRack getPositionOfChestWithSimilarItemStack(@NotNull ItemStack stack) {
        for (BlockPos pos : this.racks) {
            BlockEntity entity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)this.f_58857_, pos) || !((entity = this.m_58904_().m_7702_(pos)) instanceof AbstractTileEntityRack) || ((AbstractTileEntityRack)entity).getFreeSlots() <= 0 || !((AbstractTileEntityRack)entity).hasSimilarStack(stack)) continue;
            return (TileEntityRack)entity;
        }
        return null;
    }

    @Nullable
    private TileEntityRack searchMostEmptyRack() {
        int freeSlots = 0;
        TileEntityRack emptiestChest = null;
        for (BlockPos pos : this.racks) {
            BlockEntity entity = this.m_58904_().m_7702_(pos);
            if (!(entity instanceof TileEntityRack)) continue;
            if (((AbstractTileEntityRack)entity).isEmpty()) {
                return (TileEntityRack)entity;
            }
            int tempFreeSlots = ((AbstractTileEntityRack)entity).getFreeSlots();
            if (tempFreeSlots <= freeSlots) continue;
            freeSlots = tempFreeSlots;
            emptiestChest = (TileEntityRack)entity;
        }
        return emptiestChest;
    }

    public void addAll(Set<BlockPos> visitedPositions) {
        if (visitedPositions.size() > this.tier * 20) {
            return;
        }
        this.racks.clear();
        this.racks.addAll(visitedPositions);
        this.m_6596_();
    }

    public void removeAll(Set<BlockPos> visitedPositions) {
        this.racks.removeAll(visitedPositions);
        this.m_6596_();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction dir) {
        if (!this.f_58859_ && capability == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> new ControllerInventory());
        }
        return super.getCapability(capability, dir);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"container.title.insertion");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new InsertContainer(id, inv, (IItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse((Object)new ItemStackHandler(0)));
    }

    public class ControllerInventory
    extends ItemStackHandler {
        public ControllerInventory() {
            super(5);
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            if (((TileEntityController)TileEntityController.this).f_58857_.f_46443_) {
                return;
            }
            TileEntityController.this.insertItemStack(stack);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return TileEntityController.this.getRackForStack(stack) != null;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (((TileEntityController)TileEntityController.this).f_58857_.f_46443_) {
                return ItemStack.f_41583_;
            }
            if (simulate) {
                if (TileEntityController.this.getRackForStack(stack) == null) {
                    return stack;
                }
                return ItemStack.f_41583_;
            }
            if (!TileEntityController.this.insertItemStack(stack)) {
                return stack;
            }
            return ItemStack.f_41583_;
        }
    }
}

