/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.inv;

import com.ldtteam.storageracks.inv.ModContainers;
import com.ldtteam.storageracks.tileentities.AbstractTileEntityRack;
import com.ldtteam.storageracks.utils.ItemStackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ContainerRack
extends AbstractContainerMenu {
    private final IItemHandler inventory;
    public final AbstractTileEntityRack rack;
    private final int inventorySize;

    public static ContainerRack fromPacketBuffer(int windowId, Inventory inv, FriendlyByteBuf packetBuffer) {
        BlockPos tePos = packetBuffer.m_130135_();
        return new ContainerRack(windowId, inv, tePos);
    }

    public ContainerRack(int windowId, Inventory inv, BlockPos rack) {
        super((MenuType)ModContainers.rackInv.get(), windowId);
        int i;
        AbstractTileEntityRack abstractTileEntityRack = (AbstractTileEntityRack)inv.f_35978_.m_9236_().m_7702_(rack);
        this.inventory = abstractTileEntityRack.getInventory();
        this.rack = abstractTileEntityRack;
        this.inventorySize = this.inventory.getSlots() / 9;
        int size = this.inventory.getSlots();
        int columns = this.inventorySize <= 8 ? 9 : size / 8 + 1;
        int extraOffset = this.inventorySize <= 8 ? 0 : 2;
        int index = 0;
        for (int j = 0; j < Math.min(this.inventorySize, 8); ++j) {
            for (int k = 0; k < columns; ++k) {
                if (index >= size) continue;
                this.m_38897_((Slot)new SlotItemHandler(this.inventory, index, 8 + k * 18, 18 + j * 18));
                ++index;
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 30 + extraOffset + 18 * Math.min(this.inventorySize, 8) + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inv, i, 8 + i * 18, 88 + extraOffset + 18 * Math.min(this.inventorySize, 8)));
        }
    }

    public void m_150399_(int slotId, int dragType, @NotNull ClickType clickType, Player player) {
        if (player.m_9236_().f_46443_ || slotId >= this.inventory.getSlots() || slotId < 0) {
            super.m_150399_(slotId, dragType, clickType, player);
            return;
        }
        ItemStack currentStack = this.inventory.getStackInSlot(slotId).m_41777_();
        super.m_150399_(slotId, dragType, clickType, player);
        ItemStack afterStack = this.inventory.getStackInSlot(slotId).m_41777_();
        if (!ItemStack.m_150942_((ItemStack)currentStack, (ItemStack)afterStack)) {
            this.updateRacks();
        }
    }

    @NotNull
    public ItemStack m_7648_(Player playerIn, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot == null || !slot.m_6657_()) {
            return ItemStackUtils.EMPTY;
        }
        ItemStack stackCopy = slot.m_7993_().m_41777_();
        int maxIndex = this.inventorySize * 9;
        if (index < maxIndex ? !this.m_38903_(stackCopy, maxIndex, this.f_38839_.size(), true) : !this.m_38903_(stackCopy, 0, maxIndex, false)) {
            return ItemStackUtils.EMPTY;
        }
        if (ItemStackUtils.getSize(stackCopy) == 0) {
            slot.m_5852_(ItemStackUtils.EMPTY);
        } else {
            slot.m_5852_(stackCopy);
            slot.m_6654_();
        }
        if (playerIn instanceof ServerPlayer) {
            this.updateRacks();
        }
        return stackCopy;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean merge = super.m_38903_(stack, startIndex, endIndex, reverseDirection);
        if (merge) {
            this.updateRacks();
        }
        return merge;
    }

    private void updateRacks() {
        this.rack.updateItemStorage();
    }

    public boolean m_6875_(@NotNull Player player) {
        return true;
    }
}

