/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.gui;

import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.storageracks.HighlightManager;
import com.ldtteam.storageracks.ItemStorage;
import com.ldtteam.storageracks.gui.AbstractWindowSkeleton;
import com.ldtteam.storageracks.network.Network;
import com.ldtteam.storageracks.network.OpenInventoryMessage;
import com.ldtteam.storageracks.network.SortControllerMessage;
import com.ldtteam.storageracks.network.UnlockInsertMessage;
import com.ldtteam.storageracks.network.UnlockSortMessage;
import com.ldtteam.storageracks.tileentities.TileEntityController;
import com.ldtteam.storageracks.tileentities.TileEntityRack;
import com.ldtteam.storageracks.utils.InventoryUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class WindowHutAllInventory
extends AbstractWindowSkeleton {
    private static final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();
    public static final int RED;
    public static final int GREEN;
    List<ItemStorage> allItems = new ArrayList<ItemStorage>();
    private final ScrollingList stackList;
    private String filter = "";
    private int sortDescriptor = 0;
    private final TileEntityController controller;

    public WindowHutAllInventory(TileEntityController controller) {
        super("storageracks:gui/windowallinventory.xml");
        ItemIcon icon;
        this.controller = controller;
        this.registerButton("sortStorageFilter", this::setSortFlag);
        this.stackList = (ScrollingList)this.findPaneOfTypeByID("allinventorylist", ScrollingList.class);
        this.updateResources();
        this.registerButton("locate", this::locate);
        this.registerButton("sort", this::sort);
        this.registerButton("insert", this::insert);
        if (controller.isSortUnlocked()) {
            ((ButtonImage)this.findPaneOfTypeByID("sort", ButtonImage.class)).setText(Component.m_237115_((String)"gui.storageracks.sort"));
        } else {
            ((ButtonImage)this.findPaneOfTypeByID("sort", ButtonImage.class)).setText(Component.m_237115_((String)"gui.storageracks.sort.unlock"));
            icon = (ItemIcon)this.findPaneOfTypeByID("sortcost", ItemIcon.class);
            this.setupIcon(icon, Items.f_42153_);
        }
        if (controller.isInsertUnlocked()) {
            ((ButtonImage)this.findPaneOfTypeByID("insert", ButtonImage.class)).setText(Component.m_237115_((String)"gui.storageracks.insert"));
        } else {
            ((ButtonImage)this.findPaneOfTypeByID("insert", ButtonImage.class)).setText(Component.m_237115_((String)"gui.storageracks.insert.unlock"));
            icon = (ItemIcon)this.findPaneOfTypeByID("insertcost", ItemIcon.class);
            this.setupIcon(icon, Items.f_42155_);
        }
    }

    private void setupIcon(ItemIcon icon, Item item) {
        icon.setVisible(true);
        icon.setItem(new ItemStack((ItemLike)item, 1));
        if (InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((Container)Minecraft.m_91087_().f_91074_.m_150109_()), item) >= 0) {
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)icon).paragraphBreak()).append(Component.m_237115_((String)"gui.storage.racks.available"))).color(GREEN)).build();
        } else {
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)icon).paragraphBreak()).append(Component.m_237115_((String)"gui.storage.racks.missing"))).color(RED)).build();
        }
    }

    private void insert() {
        if (this.controller.isInsertUnlocked()) {
            Network.getNetwork().sendToServer(new OpenInventoryMessage(this.controller.m_58899_()));
        } else {
            Network.getNetwork().sendToServer(new UnlockInsertMessage(this.controller.m_58899_()));
            this.close();
        }
    }

    private void sort() {
        if (this.controller.isSortUnlocked()) {
            Network.getNetwork().sendToServer(new SortControllerMessage(this.controller.m_58899_()));
        } else {
            Network.getNetwork().sendToServer(new UnlockSortMessage(this.controller.m_58899_()));
        }
        this.close();
    }

    private void locate(Button button) {
        int row = this.stackList.getListElementIndexByPane((Pane)button);
        ItemStorage storage = this.allItems.get(row);
        HashSet<BlockPos> containerList = new HashSet<BlockPos>(this.controller.racks);
        HighlightManager.clearCategory("inventoryHighlight");
        Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"gui.storageracks.locating"), false);
        this.close();
        for (BlockPos blockPos : containerList) {
            int count;
            BlockEntity rack = Minecraft.m_91087_().f_91073_.m_7702_(blockPos);
            if (!(rack instanceof TileEntityRack) || (count = ((TileEntityRack)rack).getCount(storage.getItemStack())) <= 0) continue;
            int color = 65280 + 0xFF0000 * Math.max(0, 1 - count / 64);
            HighlightManager.addRenderBox("inventoryHighlight", new HighlightManager.TimedBoxRenderData().setPos(blockPos).setRemovalTimePoint(Minecraft.m_91087_().f_91073_.m_46467_() + 1200L).addText("" + count).setColor(color));
        }
    }

    private void setSortFlag() {
        ++this.sortDescriptor;
        if (this.sortDescriptor > 4) {
            this.sortDescriptor = 0;
        }
        switch (this.sortDescriptor) {
            case 0: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setText(Component.m_237113_((String)"v^"));
                break;
            }
            case 1: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setText(Component.m_237113_((String)"A^"));
                break;
            }
            case 2: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setText(Component.m_237113_((String)"Av"));
                break;
            }
            case 3: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setText(Component.m_237113_((String)"1^"));
                break;
            }
            case 4: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setText(Component.m_237113_((String)"1v"));
                break;
            }
        }
        this.updateResources();
    }

    private void updateResources() {
        HashSet<BlockPos> containerList = new HashSet<BlockPos>(this.controller.racks);
        HashMap<ItemStorage, Integer> storedItems = new HashMap<ItemStorage, Integer>();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        for (BlockPos blockPos : containerList) {
            BlockEntity rack = level.m_7702_(blockPos);
            if (!(rack instanceof TileEntityRack)) continue;
            Map<ItemStorage, Integer> rackStorage = ((TileEntityRack)rack).getAllContent();
            for (Map.Entry<ItemStorage, Integer> entry : rackStorage.entrySet()) {
                if (storedItems.containsKey(entry.getKey())) {
                    storedItems.put(entry.getKey(), (Integer)storedItems.get(entry.getKey()) + entry.getValue());
                    continue;
                }
                storedItems.put(entry.getKey(), entry.getValue());
            }
        }
        ArrayList filterItems = new ArrayList();
        storedItems.forEach((storage, amount) -> {
            storage.setAmount((int)amount);
            filterItems.add(storage);
        });
        Predicate<ItemStorage> filterPredicate = stack -> this.filter.isEmpty() || stack.getItemStack().m_41611_().toString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || WindowHutAllInventory.getString(stack.getItemStack()).toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US));
        this.allItems.clear();
        if (this.filter.isEmpty()) {
            this.allItems.addAll(filterItems);
        } else {
            this.allItems.addAll(filterItems.stream().filter(filterPredicate).toList());
        }
        if (!this.filter.isEmpty()) {
            this.allItems.sort(Comparator.comparingInt(s1 -> StringUtils.getLevenshteinDistance((CharSequence)s1.getItemStack().m_41786_().getString(), (CharSequence)this.filter)));
        }
        Comparator<ItemStorage> compareByName = Comparator.comparing(o -> o.getItemStack().m_41611_().getString());
        Comparator<ItemStorage> compareByCount = Comparator.comparingInt(ItemStorage::getAmount);
        switch (this.sortDescriptor) {
            case 0: {
                break;
            }
            case 1: {
                this.allItems.sort(compareByName);
                break;
            }
            case 2: {
                this.allItems.sort(compareByName.reversed());
                break;
            }
            case 3: {
                this.allItems.sort(compareByCount);
                break;
            }
            case 4: {
                this.allItems.sort(compareByCount.reversed());
                break;
            }
        }
        this.updateResourceList();
    }

    private static String getString(ItemStack stack) {
        StringBuilder output = new StringBuilder();
        for (Component comp : stack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.f_256752_)) {
            output.append(comp.getString()).append(" ");
        }
        return output.toString();
    }

    private void updateResourceList() {
        this.stackList.enable();
        this.stackList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowHutAllInventory.this.allItems.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStorage resource = WindowHutAllInventory.this.allItems.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("ressourceStackName", Text.class);
                String name = resource.getItemStack().m_41611_().getString().replace("[", "").replace("]", "");
                resourceLabel.setText(Component.m_237115_((String)name.substring(0, Math.min(17, name.length()))));
                Text qtys = (Text)rowPane.findPaneOfTypeByID("quantities", Text.class);
                if (!Screen.m_96638_()) {
                    qtys.setText(Component.m_237115_((String)WindowHutAllInventory.format(resource.getAmount())));
                } else {
                    qtys.setText(Component.m_237115_((String)Integer.toString(resource.getAmount())));
                }
                Item imagesrc = resource.getItemStack().m_41720_();
                ItemStack image = new ItemStack((ItemLike)imagesrc, 1);
                image.m_41751_(resource.getItemStack().m_41783_());
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(image);
            }
        });
    }

    public static String format(long value) {
        if (value == Long.MIN_VALUE) {
            return WindowHutAllInventory.format(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + WindowHutAllInventory.format(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)truncated / 10.0;
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    public boolean onKeyTyped(char ch, int key) {
        boolean result = super.onKeyTyped(ch, key);
        if (result) {
            this.filter = ((TextField)this.findPaneOfTypeByID("names", TextField.class)).getText();
            this.updateResources();
        }
        return result;
    }

    static {
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "M");
        suffixes.put(1000000000L, "G");
        suffixes.put(1000000000000L, "T");
        suffixes.put(1000000000000000L, "P");
        suffixes.put(1000000000000000000L, "E");
        RED = Color.rgbaToInt((int)240, (int)150, (int)135, (int)255);
        GREEN = Color.rgbaToInt((int)85, (int)255, (int)255, (int)255);
    }
}

