/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.datagen;

import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.models.item.ItemModelJson;
import com.ldtteam.storageracks.blocks.CornerBlock;
import com.ldtteam.storageracks.blocks.ModBlocks;
import com.ldtteam.storageracks.blocks.RackBlock;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ItemModelProvider
implements DataProvider {
    private final DataGenerator generator;
    private final List<Tuple<ItemModelJson, String>> models = new ArrayList<Tuple<ItemModelJson, String>>();

    public ItemModelProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
        HashMap<String, CallSite> textureMap;
        String modelLocation;
        ItemModelJson modelJson;
        for (RegistryObject<CornerBlock> registryObject : ModBlocks.corners) {
            modelJson = new ItemModelJson();
            modelLocation = "storageracks:item/corner";
            modelJson.setParent("storageracks:item/corner");
            textureMap = new HashMap<String, CallSite>();
            textureMap.put("0", (CallSite)((Object)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((CornerBlock)((Object)registryObject.get())).getWoodType().getMaterial()).m_135815_())));
            textureMap.put("1", (CallSite)((Object)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((CornerBlock)((Object)registryObject.get())).getFrameType().getMaterial()).m_135815_())));
            textureMap.put("particle", (CallSite)((Object)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((CornerBlock)((Object)registryObject.get())).getWoodType().getMaterial()).m_135815_())));
            modelJson.setTextures(textureMap);
            this.models.add((Tuple<ItemModelJson, String>)new Tuple((Object)modelJson, (Object)ForgeRegistries.BLOCKS.getKey((Object)((Block)registryObject.get())).m_135815_()));
        }
        for (RegistryObject registryObject : ModBlocks.racks) {
            modelJson = new ItemModelJson();
            modelLocation = "storageracks:item/rack";
            modelJson.setParent("storageracks:item/rack");
            textureMap = new HashMap();
            textureMap.put("0", (CallSite)((Object)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((RackBlock)((Object)registryObject.get())).getWoodType().getMaterial()).m_135815_())));
            textureMap.put("1", (CallSite)((Object)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((RackBlock)((Object)registryObject.get())).getFrameType().getMaterial()).m_135815_())));
            textureMap.put("particle", (CallSite)((Object)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((RackBlock)((Object)registryObject.get())).getWoodType().getMaterial()).m_135815_())));
            modelJson.setTextures(textureMap);
            this.models.add((Tuple<ItemModelJson, String>)new Tuple((Object)modelJson, (Object)ForgeRegistries.BLOCKS.getKey((Object)((Block)registryObject.get())).m_135815_()));
        }
        return this.generateAll(cache);
    }

    protected CompletableFuture<?> generateAll(CachedOutput cache) {
        CompletableFuture[] futures = new CompletableFuture[this.models.size()];
        int i = 0;
        for (Tuple<ItemModelJson, String> model : this.models) {
            Path target = this.getPath((String)model.m_14419_());
            futures[i++] = DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((ItemModelJson)model.m_14418_()).serialize(), (Path)target);
        }
        return CompletableFuture.allOf(futures);
    }

    protected Path getPath(String name) {
        return this.generator.getPackOutput().m_247566_(PackOutput.Target.RESOURCE_PACK).resolve("storageracks").resolve("models/item/").resolve(name + ".json");
    }

    @NotNull
    public String m_6055_() {
        return "Brick Item Model Provider";
    }
}

