/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.datagen;

import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.loot_table.LootTableJson;
import com.ldtteam.datagenerators.loot_table.LootTableTypeEnum;
import com.ldtteam.datagenerators.loot_table.pool.PoolJson;
import com.ldtteam.datagenerators.loot_table.pool.conditions.survives_explosion.SurvivesExplosionConditionJson;
import com.ldtteam.datagenerators.loot_table.pool.entry.EntryJson;
import com.ldtteam.datagenerators.loot_table.pool.entry.EntryTypeEnum;
import com.ldtteam.storageracks.blocks.CornerBlock;
import com.ldtteam.storageracks.blocks.ModBlocks;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class DefaultBlockLootTableProvider
implements DataProvider {
    private final DataGenerator generator;
    private final List<Tuple<LootTableJson, String>> models = new ArrayList<Tuple<LootTableJson, String>>();

    public DefaultBlockLootTableProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
        for (RegistryObject<CornerBlock> registryObject : ModBlocks.corners) {
            this.saveBlock((Block)registryObject.get(), cache);
        }
        for (RegistryObject registryObject : ModBlocks.racks) {
            this.saveBlock((Block)registryObject.get(), cache);
        }
        this.saveBlock((Block)ModBlocks.diamondController.get(), cache);
        this.saveBlock((Block)ModBlocks.emeraldController.get(), cache);
        this.saveBlock((Block)ModBlocks.goldController.get(), cache);
        this.saveBlock((Block)ModBlocks.ironController.get(), cache);
        this.saveBlock((Block)ModBlocks.stoneController.get(), cache);
        return this.generateAll(cache);
    }

    private void saveBlock(Block block, CachedOutput cache) {
        EntryJson entryJson = new EntryJson();
        entryJson.setType(EntryTypeEnum.ITEM);
        entryJson.setName(ForgeRegistries.BLOCKS.getKey((Object)block).toString());
        PoolJson poolJson = new PoolJson();
        poolJson.setEntries(Collections.singletonList(entryJson));
        poolJson.setRolls(1);
        poolJson.setConditions(Collections.singletonList(new SurvivesExplosionConditionJson()));
        LootTableJson lootTableJson = new LootTableJson();
        lootTableJson.setType(LootTableTypeEnum.BLOCK);
        lootTableJson.setPools(Collections.singletonList(poolJson));
        this.models.add((Tuple<LootTableJson, String>)new Tuple((Object)lootTableJson, (Object)ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_()));
    }

    protected CompletableFuture<?> generateAll(CachedOutput cache) {
        CompletableFuture[] futures = new CompletableFuture[this.models.size()];
        int i = 0;
        for (Tuple<LootTableJson, String> model : this.models) {
            Path target = this.getPath((String)model.m_14419_());
            futures[i++] = DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((LootTableJson)model.m_14418_()).serialize(), (Path)target);
        }
        return CompletableFuture.allOf(futures);
    }

    protected Path getPath(String name) {
        return this.generator.getPackOutput().m_247566_(PackOutput.Target.DATA_PACK).resolve("storageracks").resolve("loot_tables/blocks").resolve(name + ".json");
    }

    @NotNull
    public String m_6055_() {
        return "Default Block Loot Tables Provider";
    }
}

