/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.datagen;

import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.blockstate.BlockstateJson;
import com.ldtteam.datagenerators.blockstate.BlockstateModelJson;
import com.ldtteam.datagenerators.blockstate.BlockstateVariantJson;
import com.ldtteam.storageracks.blocks.CornerBlock;
import com.ldtteam.storageracks.blocks.ModBlocks;
import com.ldtteam.storageracks.blocks.RackType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class BlockStateProvider
implements DataProvider {
    private final DataGenerator generator;
    private final List<Tuple<BlockstateJson, String>> models = new ArrayList<Tuple<BlockstateJson, String>>();

    public BlockStateProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
        BlockstateJson blockstate;
        HashMap<Object, BlockstateVariantJson> variants;
        for (RegistryObject<CornerBlock> registryObject : ModBlocks.corners) {
            variants = new HashMap<Object, BlockstateVariantJson>();
            variants.put("", new BlockstateVariantJson(new BlockstateModelJson("storageracks:block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)registryObject.get())).m_135815_())));
            blockstate = new BlockstateJson(variants);
            this.models.add((Tuple<BlockstateJson, String>)new Tuple((Object)blockstate, (Object)ForgeRegistries.BLOCKS.getKey((Object)((Block)registryObject.get())).m_135815_()));
        }
        for (RegistryObject registryObject : ModBlocks.racks) {
            variants = new HashMap();
            for (RackType type : RackType.values()) {
                variants.put("variant=" + type.getName(), new BlockstateVariantJson(new BlockstateModelJson("storageracks:block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)registryObject.get())).m_135815_() + type.getName())));
            }
            blockstate = new BlockstateJson(variants);
            this.models.add((Tuple<BlockstateJson, String>)new Tuple((Object)blockstate, (Object)ForgeRegistries.BLOCKS.getKey((Object)((Block)registryObject.get())).m_135815_()));
        }
        return this.generateAll(cache);
    }

    protected CompletableFuture<?> generateAll(CachedOutput cache) {
        CompletableFuture[] futures = new CompletableFuture[this.models.size()];
        int i = 0;
        for (Tuple<BlockstateJson, String> model : this.models) {
            Path target = this.getPath((String)model.m_14419_());
            futures[i++] = DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((BlockstateJson)model.m_14418_()).serialize(), (Path)target);
        }
        return CompletableFuture.allOf(futures);
    }

    protected Path getPath(String name) {
        return this.generator.getPackOutput().m_247566_(PackOutput.Target.RESOURCE_PACK).resolve("storageracks").resolve("blockstates/").resolve(name + ".json");
    }

    @NotNull
    public String m_6055_() {
        return "Brick BlockStates Provider";
    }
}

