/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.configuration;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class AbstractConfiguration {
    private static final String BOOLEAN_DEFAULT_KEY = "storageracks.config.default.boolean";
    private static final String INT_DEFAULT_KEY = "storageracks.config.default.int";
    private static final String LONG_DEFAULT_KEY = "storageracks.config.default.long";
    private static final String DOUBLE_DEFAULT_KEY = "storageracks.config.default.double";

    protected void createCategory(ForgeConfigSpec.Builder builder, String key) {
        builder.comment(Component.m_237115_((String)AbstractConfiguration.commentTKey(key)).getString()).push(key);
    }

    protected void swapToCategory(ForgeConfigSpec.Builder builder, String key) {
        this.finishCategory(builder);
        this.createCategory(builder, key);
    }

    protected void finishCategory(ForgeConfigSpec.Builder builder) {
        builder.pop();
    }

    private static String nameTKey(String key) {
        return "storageracks.config." + key;
    }

    private static String commentTKey(String key) {
        return AbstractConfiguration.nameTKey(key) + ".comment";
    }

    private static ForgeConfigSpec.Builder buildBase(ForgeConfigSpec.Builder builder, String key, String defaultDesc) {
        return builder.comment(Component.m_237115_((String)AbstractConfiguration.commentTKey(key)).getString() + " " + defaultDesc).translation(AbstractConfiguration.nameTKey(key));
    }

    protected static ForgeConfigSpec.IntValue defineInteger(ForgeConfigSpec.Builder builder, String key, int defaultValue, int min, int max) {
        return AbstractConfiguration.buildBase(builder, key, Component.m_237110_((String)INT_DEFAULT_KEY, (Object[])new Object[]{defaultValue, min, max}).getString()).defineInRange(key, defaultValue, min, max);
    }

    protected static ForgeConfigSpec.LongValue defineLong(ForgeConfigSpec.Builder builder, String key, long defaultValue) {
        return AbstractConfiguration.defineLong(builder, key, defaultValue, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    protected static ForgeConfigSpec.LongValue defineLong(ForgeConfigSpec.Builder builder, String key, long defaultValue, long min, long max) {
        return AbstractConfiguration.buildBase(builder, key, Component.m_237110_((String)LONG_DEFAULT_KEY, (Object[])new Object[]{defaultValue, min, max}).getString()).defineInRange(key, defaultValue, min, max);
    }

    protected static ForgeConfigSpec.DoubleValue defineDouble(ForgeConfigSpec.Builder builder, String key, double defaultValue) {
        return AbstractConfiguration.defineDouble(builder, key, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    protected static ForgeConfigSpec.DoubleValue defineDouble(ForgeConfigSpec.Builder builder, String key, double defaultValue, double min, double max) {
        return AbstractConfiguration.buildBase(builder, key, Component.m_237110_((String)DOUBLE_DEFAULT_KEY, (Object[])new Object[]{defaultValue, min, max}).getString()).defineInRange(key, defaultValue, min, max);
    }

    protected static <T> ForgeConfigSpec.ConfigValue<List<? extends T>> defineList(ForgeConfigSpec.Builder builder, String key, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
        return AbstractConfiguration.buildBase(builder, key, "").defineList(key, defaultValue, elementValidator);
    }

    protected static <V extends Enum<V>> ForgeConfigSpec.EnumValue<V> defineEnum(ForgeConfigSpec.Builder builder, String key, V defaultValue) {
        return AbstractConfiguration.buildBase(builder, key, "").defineEnum(key, defaultValue);
    }
}

