/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks;

import com.ldtteam.storageracks.utils.ItemStackUtils;
import java.util.Objects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemStorage {
    private final ItemStack stack;
    private int amount;

    public ItemStorage(@NotNull ItemStack stack) {
        this.stack = stack;
        this.amount = ItemStackUtils.getSize(stack);
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int hashCode() {
        return Objects.hash(this.stack.m_41720_());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemStorage)) {
            return false;
        }
        ItemStorage that = (ItemStorage)o;
        return ItemStack.m_41656_((ItemStack)this.stack, (ItemStack)that.getItemStack()) && that.getDamageValue() == this.getDamageValue() && (that.getItemStack().m_41783_() == null && this.getItemStack().m_41783_() == null || that.getItemStack().m_41783_() != null && that.getItemStack().m_41783_().equals((Object)this.getItemStack().m_41783_()));
    }

    @NotNull
    public Item getItem() {
        return this.stack.m_41720_();
    }

    public int getDamageValue() {
        return this.stack.m_41773_();
    }

    public boolean isEmpty() {
        return ItemStackUtils.isEmpty(this.stack) != false || this.amount <= 0;
    }
}

