/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.items;

import com.google.common.base.Preconditions;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.config.Config;
import io.github.mortuusars.chalk.items.ChalkBoxItem;
import io.github.mortuusars.chalk.items.ChalkItem;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ChalkBox {
    public static final int SLOTS = 9;
    public static final int CHALK_SLOTS = 8;
    public static final int GLOWINGS_SLOT_INDEX = 8;
    public static final String GLOW_TAG_KEY = "GlowUses";
    public static final String ITEMS_TAG_KEY = "Items";

    public static List<ItemStack> getContents(ItemStack stack) {
        ChalkBox.validateChalkBoxStack(stack);
        return ChalkBox.getItemsListTag(stack).stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_).toList();
    }

    public static boolean isItemValid(int slot, @NotNull ItemStack stack) {
        if (slot < 0 || slot >= 9) {
            return false;
        }
        if (slot == 8) {
            return stack.m_204117_(Chalk.Tags.Items.GLOWINGS);
        }
        return stack.m_41720_() instanceof ChalkItem;
    }

    public static ItemStack getItemInSlot(ItemStack chalkBoxStack, int slot) {
        ChalkBox.validateChalkBoxStack(chalkBoxStack);
        ChalkBox.validateSlotIndex(slot);
        return ItemStack.m_41712_((CompoundTag)ChalkBox.getItemsListTag(chalkBoxStack).m_128728_(slot));
    }

    public static void setContents(ItemStack chalkBoxStack, List<ItemStack> items) {
        Preconditions.checkArgument((items.size() <= 9 ? 1 : 0) != 0, (Object)"List of items cannot be larger than amount of slots available.");
        for (int index = 0; index < Math.min(9, items.size()); ++index) {
            ItemStack itemStack = items.get(index);
            Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"Stack cannot be null.");
            ChalkBox.setSlot(chalkBoxStack, index, itemStack);
        }
    }

    public static void setSlot(ItemStack chalkBoxStack, int slot, ItemStack itemStack) {
        ChalkBox.validateSlotIndex(slot);
        if (itemStack.m_41619_() || ChalkBox.isItemValid(slot, itemStack)) {
            ChalkBox.updateSlotContents(chalkBoxStack, slot, itemStack);
        }
    }

    public static int getGlowLevel(ItemStack chalkBoxStack) {
        ChalkBox.validateChalkBoxStack(chalkBoxStack);
        return chalkBoxStack.m_41784_().m_128451_(GLOW_TAG_KEY);
    }

    public static void consumeGlow(ItemStack chalkBoxStack) {
        ChalkBox.validateChalkBoxStack(chalkBoxStack);
        ChalkBox.setGlow(chalkBoxStack, Math.max(ChalkBox.getGlowLevel(chalkBoxStack) - 1, 0));
        ChalkBox.updateGlow(chalkBoxStack);
    }

    public static void setGlow(ItemStack chalkBoxStack, int glow) {
        ChalkBox.validateChalkBoxStack(chalkBoxStack);
        chalkBoxStack.m_41784_().m_128405_(GLOW_TAG_KEY, glow);
    }

    private static void updateGlow(ItemStack chalkBoxStack) {
        if (ChalkBox.getGlowLevel(chalkBoxStack) > 0) {
            return;
        }
        ItemStack glowingItemStack = ChalkBox.getItemInSlot(chalkBoxStack, 8);
        if (!glowingItemStack.m_41619_()) {
            ChalkBox.setGlow(chalkBoxStack, (Integer)Config.CHALK_BOX_GLOWING_USES.get());
            glowingItemStack.m_41774_(1);
            ChalkBox.setSlot(chalkBoxStack, 8, glowingItemStack);
        }
    }

    private static void validateChalkBoxStack(@NotNull ItemStack stack) {
        Preconditions.checkArgument((!stack.m_41619_() && stack.m_41720_() instanceof ChalkBoxItem ? 1 : 0) != 0);
    }

    private static void validateSlotIndex(int slot) {
        Preconditions.checkArgument((slot >= 0 && slot < 9 ? 1 : 0) != 0, (Object)"[%s] slot is out if range: 0-%s".formatted(slot, 8));
    }

    private static void updateSlotContents(ItemStack chalkBoxStack, int slot, ItemStack itemStack) {
        ListTag itemsListTag = ChalkBox.getItemsListTag(chalkBoxStack);
        itemsListTag.set(slot, (Tag)itemStack.serializeNBT());
        ChalkBox.onItemInSlotChanged(chalkBoxStack, slot, itemStack);
    }

    private static void onItemInSlotChanged(ItemStack chalkBoxStack, int slot, ItemStack itemStack) {
        if (slot == 8) {
            ChalkBox.updateGlow(chalkBoxStack);
        }
    }

    private static ListTag getItemsListTag(ItemStack chalkBoxStack) {
        ChalkBox.validateChalkBoxStack(chalkBoxStack);
        CompoundTag compoundTag = chalkBoxStack.m_41784_();
        if (!compoundTag.m_128441_(ITEMS_TAG_KEY)) {
            ListTag itemTags = new ListTag();
            for (int index = 0; index < 9; ++index) {
                itemTags.add((Object)ItemStack.f_41583_.serializeNBT());
            }
            compoundTag.m_128365_(ITEMS_TAG_KEY, (Tag)itemTags);
        }
        return compoundTag.m_128437_(ITEMS_TAG_KEY, 10);
    }
}

